import { FROM, SELECT } from '../standardSql/language.js';
import { TokenType } from '../types.js';
import '@grafana/ui';

const getSelectToken = (currentToken) => {
  var _a;
  return (_a = currentToken == null ? undefined : currentToken.getPreviousOfType(TokenType.Keyword, SELECT)) != null ? _a : null;
};
const getFromKeywordToken = (currentToken) => {
  const selectToken = getSelectToken(currentToken);
  return selectToken == null ? undefined : selectToken.getNextOfType(TokenType.Keyword, FROM);
};
const getTableToken = (currentToken) => {
  var _a;
  const fromToken = getFromKeywordToken(currentToken);
  const nextNonWhiteSpace = fromToken == null ? undefined : fromToken.getNextNonWhiteSpaceToken();
  if (nextNonWhiteSpace == null ? undefined : nextNonWhiteSpace.isVariable()) {
    return null;
  } else if ((nextNonWhiteSpace == null ? undefined : nextNonWhiteSpace.isKeyword()) && ((_a = nextNonWhiteSpace.next) == null ? undefined : _a.is(TokenType.Parenthesis, "("))) {
    return null;
  } else {
    return nextNonWhiteSpace;
  }
};
const defaultTableNameParser = (token) => {
  const parts = token == null ? undefined : token.value.split(".");
  if ((parts == null ? undefined : parts.length) === 1) {
    return { table: parts[0] };
  } else if ((parts == null ? undefined : parts.length) === 2) {
    return { schema: parts[0], table: parts[1] };
  } else if ((parts == null ? undefined : parts.length) === 3) {
    return { catalog: parts[0], schema: parts[1], table: parts[2] };
  }
  return null;
};

export { defaultTableNameParser, getFromKeywordToken, getSelectToken, getTableToken };
//# sourceMappingURL=tokenUtils.js.map
