/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import org.jdom.Content;
import org.jdom.Document;
import org.jdom.IllegalDataException;
import org.jdom.IllegalNameException;
import org.jdom.Parent;
import org.jdom.Verifier;
import org.jdom.output.XMLOutputter;

public final class DocType
extends Content {
    private static final long serialVersionUID = 200L;
    private String elementName;
    private String publicID;
    private String systemID;
    private String internalSubset;

    public DocType(String elementName, String publicID, String systemID) {
        super(Content.CType.DocType);
        this.setElementName(elementName);
        this.setPublicID(publicID);
        this.setSystemID(systemID);
    }

    public DocType(String elementName, String systemID) {
        this(elementName, null, systemID);
    }

    public DocType(String elementName) {
        this(elementName, null, null);
    }

    public String getElementName() {
        return this.elementName;
    }

    public DocType setElementName(String elementName) {
        String reason = Verifier.checkXMLName(elementName);
        if (reason != null) {
            throw new IllegalNameException(elementName, "DocType", reason);
        }
        this.elementName = elementName;
        return this;
    }

    public String getPublicID() {
        return this.publicID;
    }

    public DocType setPublicID(String publicID) {
        String reason = Verifier.checkPublicID(publicID);
        if (reason != null) {
            throw new IllegalDataException(publicID, "DocType", reason);
        }
        this.publicID = publicID;
        return this;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public DocType setSystemID(String systemID) {
        String reason = Verifier.checkSystemLiteral(systemID);
        if (reason != null) {
            throw new IllegalDataException(systemID, "DocType", reason);
        }
        this.systemID = systemID;
        return this;
    }

    @Override
    public String getValue() {
        return "";
    }

    public void setInternalSubset(String newData) {
        this.internalSubset = newData;
    }

    public String getInternalSubset() {
        return this.internalSubset;
    }

    public String toString() {
        return "[DocType: " + new XMLOutputter().outputString(this) + "]";
    }

    @Override
    public DocType clone() {
        return (DocType)super.clone();
    }

    @Override
    public DocType detach() {
        return (DocType)super.detach();
    }

    @Override
    protected DocType setParent(Parent parent) {
        return (DocType)super.setParent(parent);
    }

    @Override
    public Document getParent() {
        return (Document)super.getParent();
    }
}

