/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.metrics;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.otlp.metrics.ExponentialHistogramDataPointMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.MetricsMarshalerUtil;
import io.opentelemetry.proto.metrics.v1.internal.ExponentialHistogram;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramData;
import java.io.IOException;

public class ExponentialHistogramMarshaler
extends MarshalerWithSize {
    private final ExponentialHistogramDataPointMarshaler[] dataPoints;
    private final ProtoEnumInfo aggregationTemporality;

    static ExponentialHistogramMarshaler create(ExponentialHistogramData histogramData) {
        ExponentialHistogramDataPointMarshaler[] dataPoints = ExponentialHistogramDataPointMarshaler.createRepeated(histogramData.getPoints());
        return new ExponentialHistogramMarshaler(dataPoints, MetricsMarshalerUtil.mapToTemporality(histogramData.getAggregationTemporality()));
    }

    private ExponentialHistogramMarshaler(ExponentialHistogramDataPointMarshaler[] dataPointMarshalers, ProtoEnumInfo aggregationTemporality) {
        super(ExponentialHistogramMarshaler.calculateSize(dataPointMarshalers, aggregationTemporality));
        this.dataPoints = dataPointMarshalers;
        this.aggregationTemporality = aggregationTemporality;
    }

    @Override
    protected void writeTo(Serializer output) throws IOException {
        output.serializeRepeatedMessage(ExponentialHistogram.DATA_POINTS, this.dataPoints);
        output.serializeEnum(ExponentialHistogram.AGGREGATION_TEMPORALITY, this.aggregationTemporality);
    }

    private static int calculateSize(ExponentialHistogramDataPointMarshaler[] dataPointMarshalers, ProtoEnumInfo aggregationTemporality) {
        int size = 0;
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ExponentialHistogram.DATA_POINTS, (Marshaler[])dataPointMarshalers);
        return size += MarshalerUtil.sizeEnum(ExponentialHistogram.AGGREGATION_TEMPORALITY, aggregationTemporality);
    }
}

