/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.ByteBufferCleaner;
import com.intellij.util.lang.EmptyZipFile;
import com.intellij.util.lang.ImmutableZipEntry;
import com.intellij.util.lang.ImmutableZipFile;
import com.intellij.util.lang.Xxh3;
import com.intellij.util.lang.ZipFile;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class HashMapZipFile
implements ZipFile {
    private final ImmutableZipEntry[] nameMap;
    private final ImmutableZipEntry[] entries;
    ByteBuffer mappedBuffer;
    final int fileSize;

    private HashMapZipFile(ImmutableZipEntry[] nameMap, ImmutableZipEntry[] entries, ByteBuffer mappedBuffer, int fileSize) {
        this.mappedBuffer = mappedBuffer;
        this.fileSize = fileSize;
        this.nameMap = nameMap;
        this.entries = entries;
    }

    @NotNull
    public static HashMapZipFile load(@NotNull Path file) throws IOException {
        if (file == null) {
            HashMapZipFile.$$$reportNull$$$0(0);
        }
        HashMapZipFile hashMapZipFile = (HashMapZipFile)ImmutableZipFile.load(file, true);
        if (hashMapZipFile == null) {
            HashMapZipFile.$$$reportNull$$$0(1);
        }
        return hashMapZipFile;
    }

    @Nullable
    public static HashMapZipFile loadIfNotEmpty(@NotNull Path file) throws IOException {
        ZipFile result;
        if (file == null) {
            HashMapZipFile.$$$reportNull$$$0(2);
        }
        return (result = ImmutableZipFile.load(file, true)) instanceof EmptyZipFile ? null : (HashMapZipFile)result;
    }

    @NotNull
    static HashMapZipFile createHashMapZipFile(@NotNull ByteBuffer buffer, int fileSize, int entryCount, int centralDirSize, int centralDirPosition) throws EOFException {
        int entrySetLength;
        ImmutableZipEntry[] entrySet;
        int fileEntryCount;
        ImmutableZipEntry[] entries;
        if (buffer == null) {
            HashMapZipFile.$$$reportNull$$$0(3);
        }
        if (entryCount == 65535) {
            entryCount = centralDirPosition / 47;
        }
        if ((entries = new ImmutableZipEntry[entryCount]).length != (fileEntryCount = HashMapZipFile.readCentralDirectory(buffer, centralDirPosition, centralDirSize, entrySet = new ImmutableZipEntry[entrySetLength = entryCount * 2], entries))) {
            ImmutableZipEntry[] resizedEntries = new ImmutableZipEntry[fileEntryCount];
            System.arraycopy(entries, 0, resizedEntries, 0, fileEntryCount);
            entries = resizedEntries;
        }
        buffer.clear();
        return new HashMapZipFile(entrySet, entries, buffer, fileSize);
    }

    @NotNull
    public ByteBuffer __getRawSlice() {
        ByteBuffer byteBuffer = this.mappedBuffer;
        if (byteBuffer == null) {
            HashMapZipFile.$$$reportNull$$$0(4);
        }
        return byteBuffer;
    }

    @Override
    public void processResources(@NotNull String dir, @NotNull Predicate<? super String> nameFilter, @NotNull BiConsumer<? super String, ? super InputStream> consumer) throws IOException {
        if (dir == null) {
            HashMapZipFile.$$$reportNull$$$0(5);
        }
        if (nameFilter == null) {
            HashMapZipFile.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            HashMapZipFile.$$$reportNull$$$0(7);
        }
        int minNameLength = dir.length() + 2;
        for (ImmutableZipEntry entry : this.entries) {
            String name = entry.getName();
            if (name.length() < minNameLength || name.charAt(dir.length()) != '/' || !name.startsWith(dir) || !nameFilter.test(name)) continue;
            try (InputStream stream = entry.getInputStream(this);){
                consumer.accept(name, stream);
            }
        }
    }

    @Override
    @Nullable
    public InputStream getInputStream(@NotNull String path) throws IOException {
        if (path == null) {
            HashMapZipFile.$$$reportNull$$$0(8);
        }
        ImmutableZipEntry entry = this.getRawEntry(path.charAt(0) == '/' ? path.substring(1) : path);
        return entry == null ? null : entry.getInputStream(this);
    }

    @Override
    public byte @Nullable [] getData(@NotNull String path) throws IOException {
        if (path == null) {
            HashMapZipFile.$$$reportNull$$$0(9);
        }
        ImmutableZipEntry entry = this.getRawEntry(path.charAt(0) == '/' ? path.substring(1) : path);
        return entry == null ? null : entry.getData(this);
    }

    @Override
    public ByteBuffer getByteBuffer(@NotNull String path) throws IOException {
        if (path == null) {
            HashMapZipFile.$$$reportNull$$$0(10);
        }
        ImmutableZipEntry entry = this.getRawEntry(path.charAt(0) == '/' ? path.substring(1) : path);
        return entry == null ? null : entry.getByteBuffer(this, null);
    }

    @Override
    @Nullable
    public ZipFile.ZipResource getResource(String name) {
        final ImmutableZipEntry entry = this.getRawEntry(name);
        if (entry == null) {
            return null;
        }
        return new ZipFile.ZipResource(){

            @Override
            @NotNull
            public String getPath() {
                String string = entry.name;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public int getUncompressedSize() {
                return entry.uncompressedSize;
            }

            @Override
            @NotNull
            public ByteBuffer getByteBuffer() throws IOException {
                ByteBuffer byteBuffer = entry.getByteBuffer(HashMapZipFile.this, null);
                if (byteBuffer == null) {
                    1.$$$reportNull$$$0(1);
                }
                return byteBuffer;
            }

            @Override
            public byte @NotNull [] getData() throws IOException {
                byte[] byArray = entry.getData(HashMapZipFile.this);
                if (byArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return byArray;
            }

            @Override
            @NotNull
            public InputStream getInputStream() throws IOException {
                InputStream inputStream = entry.getInputStream(HashMapZipFile.this);
                if (inputStream == null) {
                    1.$$$reportNull$$$0(3);
                }
                return inputStream;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/lang/HashMapZipFile$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getByteBuffer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getData";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInputStream";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Nullable
    public ImmutableZipEntry getRawEntry(String name) {
        int index = HashMapZipFile.probe(name, Xxh3.hash(name.getBytes(StandardCharsets.UTF_8)), this.nameMap);
        return index < 0 ? null : this.nameMap[index];
    }

    public ImmutableZipEntry[] getEntries() {
        return this.entries;
    }

    public ImmutableZipEntry[] getRawNameSet() {
        return this.nameMap;
    }

    private static int readCentralDirectory(ByteBuffer buffer, int centralDirPosition, int centralDirSize, ImmutableZipEntry[] entrySet, ImmutableZipEntry[] entries) throws EOFException {
        int commentLength;
        int extraFieldLength;
        int nameLengthInBytes;
        int entryIndex = 0;
        byte[] tempNameBytes = new byte[4096];
        ImmutableZipEntry prevEntry = null;
        int prevEntryExpectedDataOffset = -1;
        int endOffset = centralDirPosition + centralDirSize;
        for (int offset = centralDirPosition; offset < endOffset; offset += nameLengthInBytes + extraFieldLength + commentLength) {
            ImmutableZipEntry entry;
            int extraSuffixLength;
            if (buffer.getInt(offset) != 33639248) {
                throw new EOFException("No valid central directory file header signature present (expectedCentralDirectorySize=" + centralDirSize + ", expectedCentralDirectoryOffset=" + offset + ")");
            }
            int compressedSize = buffer.getInt(offset + 20);
            int uncompressedSize = buffer.getInt(offset + 24);
            int headerOffset = buffer.getInt(offset + 42);
            byte method = (byte)(buffer.getShort(offset + 10) & 0xFFFF);
            nameLengthInBytes = buffer.getShort(offset + 28) & 0xFFFF;
            extraFieldLength = buffer.getShort(offset + 30) & 0xFFFF;
            commentLength = buffer.getShort(offset + 32) & 0xFFFF;
            if (prevEntry != null && prevEntryExpectedDataOffset == headerOffset - prevEntry.compressedSize) {
                prevEntry.setDataOffset(prevEntryExpectedDataOffset);
            }
            buffer.position(offset += 46);
            if (buffer.get(offset + nameLengthInBytes - 1) == 47) {
                uncompressedSize = -2;
                compressedSize = -2;
                extraSuffixLength = 1;
            } else {
                extraSuffixLength = 0;
            }
            buffer.get(tempNameBytes, 0, nameLengthInBytes);
            String name = new String(tempNameBytes, 0, nameLengthInBytes - extraSuffixLength, StandardCharsets.UTF_8);
            int entrySetIndex = HashMapZipFile.probe(name, Xxh3.hash(tempNameBytes, 0, nameLengthInBytes - extraSuffixLength), entrySet);
            if (entrySetIndex >= 0) {
                prevEntry = null;
                continue;
            }
            prevEntry = entry = new ImmutableZipEntry(name, compressedSize, uncompressedSize, headerOffset, nameLengthInBytes, method);
            prevEntryExpectedDataOffset = headerOffset + 30 + nameLengthInBytes + extraFieldLength;
            entrySet[-(entrySetIndex + 1)] = entry;
            entries[entryIndex++] = entry;
        }
        return entryIndex;
    }

    private static int probe(String key, long keyHash, ImmutableZipEntry[] set) {
        int index = (int)(((long)((int)keyHash) & 0xFFFFFFFFL) * (long)set.length >>> 32);
        ImmutableZipEntry found;
        while ((found = set[index]) != null) {
            if (key.equals(found.name)) {
                return index;
            }
            if (++index != set.length) continue;
            index = 0;
        }
        return -index - 1;
    }

    @Override
    public void close() throws Exception {
        ByteBuffer buffer = this.mappedBuffer;
        if (buffer != null) {
            this.mappedBuffer = null;
            ByteBufferCleaner.unmapBuffer(buffer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/HashMapZipFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameFilter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/HashMapZipFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "__getRawSlice";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadIfNotEmpty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createHashMapZipFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getByteBuffer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

