/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.ClassicConstants;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.boolex.OnErrorEvaluator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.net.SMTPAppenderBase;
import java.util.List;
import java.util.concurrent.Future;
import org.slf4j.Marker;

public class SMTPAppender
extends SMTPAppenderBase<ILoggingEvent> {
    static final String DEFAULT_SUBJECT_PATTERN = "%logger{20} - %m";
    private boolean includeCallerData = false;

    public SMTPAppender() {
    }

    @Override
    public void start() {
        if (this.eventEvaluator == null) {
            OnErrorEvaluator onError = new OnErrorEvaluator();
            onError.setContext(this.getContext());
            onError.setName("onError");
            onError.start();
            this.eventEvaluator = onError;
        }
        super.start();
    }

    public SMTPAppender(EventEvaluator<ILoggingEvent> eventEvaluator) {
        this.eventEvaluator = eventEvaluator;
    }

    @Override
    protected void subAppend(CyclicBuffer<ILoggingEvent> cb5, ILoggingEvent event) {
        if (this.includeCallerData) {
            event.getCallerData();
        }
        event.prepareForDeferredProcessing();
        cb5.add(event);
    }

    @Override
    protected void fillBuffer(CyclicBuffer<ILoggingEvent> cb5, StringBuffer sbuf) {
        int len = cb5.length();
        for (int i15 = 0; i15 < len; ++i15) {
            ILoggingEvent event = cb5.get();
            sbuf.append(this.layout.doLayout(event));
        }
    }

    @Override
    protected boolean eventMarksEndOfLife(ILoggingEvent eventObject) {
        List<Marker> markers = eventObject.getMarkerList();
        if (markers == null || markers.isEmpty()) {
            return false;
        }
        for (Marker marker : markers) {
            if (!marker.contains(ClassicConstants.FINALIZE_SESSION_MARKER)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Layout<ILoggingEvent> makeSubjectLayout(String subjectStr) {
        if (subjectStr == null) {
            subjectStr = DEFAULT_SUBJECT_PATTERN;
        }
        PatternLayout pl4 = new PatternLayout();
        pl4.setContext(this.getContext());
        pl4.setPattern(subjectStr);
        pl4.setPostCompileProcessor(null);
        pl4.start();
        return pl4;
    }

    protected PatternLayout makeNewToPatternLayout(String toPattern) {
        PatternLayout pl4 = new PatternLayout();
        pl4.setPattern(toPattern + "%nopex");
        return pl4;
    }

    public boolean isIncludeCallerData() {
        return this.includeCallerData;
    }

    public void setIncludeCallerData(boolean includeCallerData) {
        this.includeCallerData = includeCallerData;
    }

    Future<?> getAsynchronousSendingFuture() {
        return this.asynchronousSendingFuture;
    }
}

