/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo;

import java.util.LinkedHashMap;
import java.util.Map;

class LRUMessageCache
extends LinkedHashMap<String, Integer> {
    private static final long serialVersionUID = 1L;
    final int cacheSize;

    LRUMessageCache(int cacheSize) {
        super((int)((float)cacheSize * 1.3333334f), 0.75f, true);
        if (cacheSize < 1) {
            throw new IllegalArgumentException("Cache size cannot be smaller than 1");
        }
        this.cacheSize = cacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMessageCountAndThenIncrement(String msg) {
        Integer i15;
        if (msg == null) {
            return 0;
        }
        LRUMessageCache lRUMessageCache = this;
        synchronized (lRUMessageCache) {
            i15 = (Integer)super.get(msg);
            i15 = i15 == null ? Integer.valueOf(0) : Integer.valueOf(i15 + 1);
            super.put(msg, i15);
        }
        return i15;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, Integer> eldest) {
        return this.size() > this.cacheSize;
    }

    @Override
    public synchronized void clear() {
        super.clear();
    }
}

