/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.BaseModelAction;
import ch.qos.logback.core.joran.action.PreconditionValidator;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.model.ConversionRuleModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class ConversionRuleAction
extends BaseModelAction {
    public static String CONVERTER_CLASS_ATTRIBUTE = "converterClass";

    @Override
    protected boolean validPreconditions(SaxEventInterpretationContext seic, String name, Attributes attributes) {
        boolean multipleClassAttributes;
        boolean missingClass;
        PreconditionValidator pv4 = new PreconditionValidator(this, seic, name, attributes);
        boolean invalidConverterClassAttribute = pv4.isInvalidAttribute(CONVERTER_CLASS_ATTRIBUTE);
        boolean invalidClassAttribute = pv4.isInvalidAttribute("class");
        if (!invalidConverterClassAttribute) {
            pv4.addWarn("[" + CONVERTER_CLASS_ATTRIBUTE + "] attribute is deprecated and replaced by [class]. " + pv4.getLocationSuffix());
        }
        boolean bl4 = missingClass = invalidClassAttribute && invalidConverterClassAttribute;
        if (missingClass) {
            pv4.addMissingAttributeError("class");
            return false;
        }
        boolean bl5 = multipleClassAttributes = !invalidClassAttribute && !invalidConverterClassAttribute;
        if (multipleClassAttributes) {
            pv4.addWarn("Both [" + CONVERTER_CLASS_ATTRIBUTE + "] attribute and [class] attribute specified. ");
            pv4.addWarn("[class] attribute will override. ");
        }
        pv4.validateGivenAttribute("conversionWord");
        return pv4.isValid();
    }

    @Override
    protected Model buildCurrentModel(SaxEventInterpretationContext interpretationContext, String name, Attributes attributes) {
        String classStr;
        ConversionRuleModel conversionRuleModel = new ConversionRuleModel();
        conversionRuleModel.setConversionWord(attributes.getValue("conversionWord"));
        String converterClassStr = attributes.getValue(CONVERTER_CLASS_ATTRIBUTE);
        if (!OptionHelper.isNullOrEmpty(converterClassStr)) {
            conversionRuleModel.setClassName(converterClassStr);
        }
        if (!OptionHelper.isNullOrEmpty(classStr = attributes.getValue("class"))) {
            conversionRuleModel.setClassName(classStr);
        }
        return conversionRuleModel;
    }
}

