/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.IUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.Strings;
import com.beust.jcommander.WrappedParameter;
import com.beust.jcommander.internal.Lists;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;

public class DefaultUsageFormatter
implements IUsageFormatter {
    private final JCommander commander;

    public DefaultUsageFormatter(JCommander commander) {
        this.commander = commander;
    }

    @Override
    public final void usage(String commandName) {
        StringBuilder sb5 = new StringBuilder();
        this.usage(commandName, sb5);
        this.commander.getConsole().println(sb5.toString());
    }

    @Override
    public final void usage(String commandName, StringBuilder out) {
        this.usage(commandName, out, "");
    }

    @Override
    public final void usage(StringBuilder out) {
        this.usage(out, "");
    }

    @Override
    public final void usage(String commandName, StringBuilder out, String indent) {
        String description = this.getCommandDescription(commandName);
        JCommander jc5 = this.commander.findCommandByAlias(commandName);
        if (description != null) {
            out.append(indent).append(description);
            out.append("\n");
        }
        jc5.getUsageFormatter().usage(out, indent);
    }

    @Override
    public void usage(StringBuilder out, String indent) {
        if (this.commander.getDescriptions() == null) {
            this.commander.createDescriptions();
        }
        boolean hasCommands = !this.commander.getCommands().isEmpty();
        boolean hasOptions = !this.commander.getDescriptions().isEmpty();
        int descriptionIndent = 6;
        int indentCount = indent.length() + 6;
        this.appendMainLine(out, hasOptions, hasCommands, indentCount, indent);
        int longestName = 0;
        List<ParameterDescription> sortedParameters = Lists.newArrayList();
        for (ParameterDescription pd5 : this.commander.getFields().values()) {
            if (pd5.getParameter().hidden()) continue;
            sortedParameters.add(pd5);
            int length = pd5.getNames().length() + 2;
            if (length <= longestName) continue;
            longestName = length;
        }
        sortedParameters.sort(this.commander.getParameterDescriptionComparator());
        this.appendAllParametersDetails(out, indentCount, indent, sortedParameters);
        if (hasCommands) {
            this.appendCommands(out, indentCount, 6, indent);
        }
    }

    public void appendMainLine(StringBuilder out, boolean hasOptions, boolean hasCommands, int indentCount, String indent) {
        String programName = this.commander.getProgramDisplayName() != null ? this.commander.getProgramDisplayName() : "<main class>";
        StringBuilder mainLine = new StringBuilder();
        mainLine.append(indent).append("Usage: ").append(programName);
        if (hasOptions) {
            mainLine.append(" [options]");
        }
        if (hasCommands) {
            mainLine.append(indent).append(" [command] [command options]");
        }
        if (this.commander.getMainParameter() != null && this.commander.getMainParameter().getDescription() != null) {
            mainLine.append(" ").append(this.commander.getMainParameter().getDescription().getDescription());
        }
        this.wrapDescription(out, indentCount, mainLine.toString());
        out.append("\n");
    }

    public void appendAllParametersDetails(StringBuilder out, int indentCount, String indent, List<ParameterDescription> sortedParameters) {
        if (sortedParameters.size() > 0) {
            out.append(indent).append("  Options:\n");
        }
        for (ParameterDescription pd5 : sortedParameters) {
            Class<?> type;
            String category;
            WrappedParameter parameter = pd5.getParameter();
            String description = pd5.getDescription();
            boolean hasDescription = !description.isEmpty();
            out.append(indent).append("  ").append(parameter.required() ? "* " : "  ").append(pd5.getNames()).append("\n");
            if (hasDescription) {
                this.wrapDescription(out, indentCount, DefaultUsageFormatter.s(indentCount) + description);
            }
            if (!(category = pd5.getCategory()).isEmpty()) {
                String categoryType = "Category: " + category;
                if (hasDescription) {
                    out.append(DefaultUsageFormatter.newLineAndIndent(indentCount));
                } else {
                    out.append(DefaultUsageFormatter.s(indentCount));
                }
                out.append(categoryType);
            }
            Object def = pd5.getDefaultValueDescription();
            if (pd5.isDynamicParameter()) {
                String syntax = "Syntax: " + parameter.names()[0] + "key" + parameter.getAssignment() + "value";
                if (hasDescription) {
                    out.append(DefaultUsageFormatter.newLineAndIndent(indentCount));
                } else {
                    out.append(DefaultUsageFormatter.s(indentCount));
                }
                out.append(syntax);
            }
            if (def != null && !pd5.isHelp()) {
                String displayedDef = Strings.isStringEmpty(def.toString()) ? "<empty string>" : def.toString();
                String defaultText = "Default: " + (parameter.password() ? "********" : displayedDef);
                if (hasDescription) {
                    out.append(DefaultUsageFormatter.newLineAndIndent(indentCount));
                } else {
                    out.append(DefaultUsageFormatter.s(indentCount));
                }
                out.append(defaultText);
            }
            if ((type = pd5.getParameterized().getType()).isEnum()) {
                String valueList = EnumSet.allOf(type).toString();
                String possibleValues = "Possible Values: " + valueList;
                if (!description.contains("Options: " + valueList)) {
                    if (hasDescription) {
                        out.append(DefaultUsageFormatter.newLineAndIndent(indentCount));
                    } else {
                        out.append(DefaultUsageFormatter.s(indentCount));
                    }
                    out.append(possibleValues);
                }
            }
            out.append("\n");
        }
    }

    public void appendCommands(StringBuilder out, int indentCount, int descriptionIndent, String indent) {
        Parameters p15;
        Object arg;
        boolean hasOnlyHiddenCommands = true;
        for (Map.Entry<JCommander.ProgramName, JCommander> commands : this.commander.getRawCommands().entrySet()) {
            arg = commands.getValue().getObjects().get(0);
            p15 = arg.getClass().getAnnotation(Parameters.class);
            if (p15 != null && p15.hidden()) continue;
            hasOnlyHiddenCommands = false;
        }
        if (hasOnlyHiddenCommands) {
            return;
        }
        out.append(indent + "  Commands:\n");
        for (Map.Entry<JCommander.ProgramName, JCommander> commands : this.commander.getRawCommands().entrySet()) {
            arg = commands.getValue().getObjects().get(0);
            p15 = arg.getClass().getAnnotation(Parameters.class);
            if (p15 != null && p15.hidden()) continue;
            JCommander.ProgramName progName = commands.getKey();
            String dispName = progName.getDisplayName();
            String commandDescription = Optional.ofNullable(this.getCommandDescription(progName.getName())).map(desc -> DefaultUsageFormatter.s(6) + desc).orElse("");
            String description = indent + DefaultUsageFormatter.s(4) + dispName + commandDescription;
            this.wrapDescription(out, indentCount + descriptionIndent, description);
            out.append("\n");
            JCommander jc5 = this.commander.findCommandByAlias(progName.getName());
            jc5.getUsageFormatter().usage(out, indent + DefaultUsageFormatter.s(6));
            out.append("\n");
        }
    }

    @Override
    public String getCommandDescription(String commandName) {
        JCommander jc5 = this.commander.findCommandByAlias(commandName);
        if (jc5 == null) {
            throw new ParameterException("Asking description for unknown command: " + commandName);
        }
        Object arg = jc5.getObjects().get(0);
        Parameters p15 = arg.getClass().getAnnotation(Parameters.class);
        String result = null;
        if (p15 != null) {
            String descriptionKey;
            result = p15.commandDescription();
            String bundleName = p15.resourceBundle();
            ResourceBundle bundle = !bundleName.isEmpty() ? ResourceBundle.getBundle(bundleName, Locale.getDefault()) : this.commander.getBundle();
            if (bundle != null && !(descriptionKey = p15.commandDescriptionKey()).isEmpty()) {
                result = DefaultUsageFormatter.getI18nString(bundle, descriptionKey, p15.commandDescription());
            }
        }
        return result;
    }

    public void wrapDescription(StringBuilder out, int indent, int currentLineIndent, String description) {
        int max = this.commander.getColumnSize();
        String[] words = description.split(" ");
        int current = currentLineIndent;
        for (int i15 = 0; i15 < words.length; ++i15) {
            String word = words[i15];
            if (word.length() > max || current + 1 + word.length() <= max) {
                out.append(word);
                current += word.length();
                if (i15 == words.length - 1) continue;
                out.append(" ");
                ++current;
                continue;
            }
            out.append("\n").append(DefaultUsageFormatter.s(indent)).append(word).append(" ");
            current = indent + word.length() + 1;
        }
    }

    public void wrapDescription(StringBuilder out, int indent, String description) {
        this.wrapDescription(out, indent, 0, description);
    }

    public static String getI18nString(ResourceBundle bundle, String key, String def) {
        String s15 = bundle != null ? bundle.getString(key) : null;
        return s15 != null ? s15 : def;
    }

    public static String s(int count) {
        StringBuilder result = new StringBuilder();
        for (int i15 = 0; i15 < count; ++i15) {
            result.append(" ");
        }
        return result.toString();
    }

    private static String newLineAndIndent(int indent) {
        return "\n" + DefaultUsageFormatter.s(indent);
    }
}

