/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.util;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public final class ShapeUtil {
    private static final int NON_RECTILINEAR_TRANSFORM_MASK = 48;

    private ShapeUtil() {
    }

    public static boolean isInvalidArea(@NotNull Rectangle2D area) {
        return area.isEmpty() || Double.isNaN(area.getWidth()) || Double.isNaN(area.getHeight());
    }

    @NotNull
    public static Shape intersect(@NotNull Shape s15, @NotNull Shape s25, boolean keep1, boolean keep2) {
        if (s15 instanceof Rectangle && s25 instanceof Rectangle) {
            return ((Rectangle)s15).intersection((Rectangle)s25);
        }
        if (s15 instanceof Rectangle2D) {
            return ShapeUtil.intersectRectShape((Rectangle2D)s15, s25, keep1, keep2);
        }
        if (s25 instanceof Rectangle2D) {
            return ShapeUtil.intersectRectShape((Rectangle2D)s25, s15, keep2, keep1);
        }
        return ShapeUtil.intersectByArea(s15, s25, keep1, keep2);
    }

    @NotNull
    private static Shape intersectRectShape(@NotNull Rectangle2D r15, @NotNull Shape s15, boolean keep1, boolean keep2) {
        if (s15 instanceof Rectangle2D) {
            Rectangle2D r25 = (Rectangle2D)s15;
            Rectangle2D outputRect = !keep1 ? r15 : (!keep2 ? r25 : new Rectangle2D.Float());
            double x15 = Math.max(r15.getX(), r25.getX());
            double x25 = Math.min(r15.getX() + r15.getWidth(), r25.getX() + r25.getWidth());
            double y15 = Math.max(r15.getY(), r25.getY());
            double y25 = Math.min(r15.getY() + r15.getHeight(), r25.getY() + r25.getHeight());
            if (x25 - x15 < 0.0 || y25 - y15 < 0.0) {
                outputRect.setFrameFromDiagonal(0.0, 0.0, 0.0, 0.0);
            } else {
                outputRect.setFrameFromDiagonal(x15, y15, x25, y25);
            }
            return outputRect;
        }
        if (r15.contains(s15.getBounds2D())) {
            if (keep2) {
                s15 = ShapeUtil.cloneShape(s15);
            }
            return s15;
        }
        return ShapeUtil.intersectByArea(r15, s15, keep1, keep2);
    }

    @NotNull
    private static Shape intersectByArea(@NotNull Shape s15, @NotNull Shape s25, boolean keep1, boolean keep2) {
        Area a15;
        if (!keep1 && s15 instanceof Area) {
            a15 = (Area)s15;
        } else if (!keep2 && s25 instanceof Area) {
            a15 = (Area)s25;
            s25 = s15;
        } else {
            a15 = new Area(s15);
        }
        Area a25 = s25 instanceof Area ? (Area)s25 : new Area(s25);
        a15.intersect(a25);
        if (a15.isRectangular()) {
            return a15.getBounds2D();
        }
        return a15;
    }

    @NotNull
    public static Shape transformShape(@NotNull Shape s15, @NotNull AffineTransform transform) {
        if (transform.getType() > 1) {
            return ShapeUtil.transformShape(transform, s15);
        }
        return ShapeUtil.transformShape(transform.getTranslateX(), transform.getTranslateY(), s15);
    }

    private static Shape transformShape(@NotNull AffineTransform tx4, @NotNull Shape shape) {
        if (shape instanceof Rectangle2D && (tx4.getType() & 0x30) == 0) {
            double[] matrix;
            Rectangle2D rect = (Rectangle2D)shape;
            matrix = new double[]{rect.getX(), rect.getY(), matrix[0] + rect.getWidth(), matrix[1] + rect.getHeight()};
            tx4.transform(matrix, 0, matrix, 0, 2);
            ShapeUtil.fixRectangleOrientation(matrix, rect);
            return new Rectangle2D.Double(matrix[0], matrix[1], matrix[2] - matrix[0], matrix[3] - matrix[1]);
        }
        if (tx4.isIdentity()) {
            return ShapeUtil.cloneShape(shape);
        }
        return tx4.createTransformedShape(shape);
    }

    private static void fixRectangleOrientation(double[] m15, @NotNull Rectangle2D r15) {
        double t15;
        if (r15.getWidth() > 0.0 != m15[2] - m15[0] > 0.0) {
            t15 = m15[0];
            m15[0] = m15[2];
            m15[2] = t15;
        }
        if (r15.getHeight() > 0.0 != m15[3] - m15[1] > 0.0) {
            t15 = m15[1];
            m15[1] = m15[3];
            m15[3] = t15;
        }
    }

    @NotNull
    private static Shape transformShape(double tx4, double ty4, @NotNull Shape s15) {
        if (s15 instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)s15;
            return new Rectangle2D.Double(rect.getX() + tx4, rect.getY() + ty4, rect.getWidth(), rect.getHeight());
        }
        if (tx4 == 0.0 && ty4 == 0.0) {
            return ShapeUtil.cloneShape(s15);
        }
        AffineTransform mat = AffineTransform.getTranslateInstance(tx4, ty4);
        return mat.createTransformedShape(s15);
    }

    private static Shape cloneShape(Shape s15) {
        return new GeneralPath(s15);
    }
}

