/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.InlineMe;
import com.google.errorprone.annotations.InlineMeValidationDisabled;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;

@GwtCompatible
public final class Strings {
    private Strings() {
    }

    public static String nullToEmpty(@Nullable String string) {
        return Platform.nullToEmpty(string);
    }

    public static @Nullable String emptyToNull(@Nullable String string) {
        return Platform.emptyToNull(string);
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return Platform.stringIsNullOrEmpty(string);
    }

    public static String padStart(String string, int minLength, char padChar) {
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb5 = new StringBuilder(minLength);
        for (int i15 = string.length(); i15 < minLength; ++i15) {
            sb5.append(padChar);
        }
        sb5.append(string);
        return sb5.toString();
    }

    public static String padEnd(String string, int minLength, char padChar) {
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb5 = new StringBuilder(minLength);
        sb5.append(string);
        for (int i15 = string.length(); i15 < minLength; ++i15) {
            sb5.append(padChar);
        }
        return sb5.toString();
    }

    @InlineMe(replacement="string.repeat(count)")
    @InlineMeValidationDisabled(value="Java 11+ API only")
    public static String repeat(String string, int count) {
        int n15;
        Preconditions.checkNotNull(string);
        if (count <= 1) {
            Preconditions.checkArgument(count >= 0, "invalid count: %s", count);
            return count == 0 ? "" : string;
        }
        int len = string.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + longSize);
        }
        char[] array = new char[size];
        string.getChars(0, len, array, 0);
        for (n15 = len; n15 < size - n15; n15 <<= 1) {
            System.arraycopy(array, 0, array, n15, n15);
        }
        System.arraycopy(array, 0, array, n15, size - n15);
        return new String(array);
    }

    public static String commonPrefix(CharSequence a15, CharSequence b15) {
        int p15;
        Preconditions.checkNotNull(a15);
        Preconditions.checkNotNull(b15);
        int maxPrefixLength = Math.min(a15.length(), b15.length());
        for (p15 = 0; p15 < maxPrefixLength && a15.charAt(p15) == b15.charAt(p15); ++p15) {
        }
        if (Strings.validSurrogatePairAt(a15, p15 - 1) || Strings.validSurrogatePairAt(b15, p15 - 1)) {
            --p15;
        }
        return a15.subSequence(0, p15).toString();
    }

    public static String commonSuffix(CharSequence a15, CharSequence b15) {
        int s15;
        Preconditions.checkNotNull(a15);
        Preconditions.checkNotNull(b15);
        int maxSuffixLength = Math.min(a15.length(), b15.length());
        for (s15 = 0; s15 < maxSuffixLength && a15.charAt(a15.length() - s15 - 1) == b15.charAt(b15.length() - s15 - 1); ++s15) {
        }
        if (Strings.validSurrogatePairAt(a15, a15.length() - s15 - 1) || Strings.validSurrogatePairAt(b15, b15.length() - s15 - 1)) {
            --s15;
        }
        return a15.subSequence(a15.length() - s15, a15.length()).toString();
    }

    @VisibleForTesting
    static boolean validSurrogatePairAt(CharSequence string, int index) {
        return index >= 0 && index <= string.length() - 2 && Character.isHighSurrogate(string.charAt(index)) && Character.isLowSurrogate(string.charAt(index + 1));
    }

    public static String lenientFormat(@Nullable String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        if (args == null) {
            args = new Object[]{"(Object[])null"};
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i15 = 0;
        while (i15 < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(Strings.lenientToString(args[i15++]));
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i15 < args.length) {
            String prefix = " [";
            while (i15 < args.length) {
                builder.append(prefix);
                builder.append(Strings.lenientToString(args[i15]));
                prefix = ", ";
                ++i15;
            }
            builder.append(']');
        }
        return builder.toString();
    }

    private static String lenientToString(@Nullable Object o15) {
        if (o15 == null) {
            return "null";
        }
        try {
            return o15.toString();
        }
        catch (Exception e15) {
            String objectToString = o15.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(o15));
            Logger.getLogger("com.google.common.base.Strings").log(Level.WARNING, "Exception during lenientFormat for " + objectToString, e15);
            return "<" + objectToString + " threw " + e15.getClass().getName() + ">";
        }
    }
}

