/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.ArrayBasedEscaperMap;
import com.google.common.escape.UnicodeEscaper;
import java.util.Map;
import org.jspecify.annotations.Nullable;

@GwtCompatible
public abstract class ArrayBasedUnicodeEscaper
extends UnicodeEscaper {
    private final char[][] replacements;
    private final int replacementsLength;
    private final int safeMin;
    private final int safeMax;
    private final char safeMinChar;
    private final char safeMaxChar;

    protected ArrayBasedUnicodeEscaper(Map<Character, String> replacementMap, int safeMin, int safeMax, @Nullable String unsafeReplacement) {
        this(ArrayBasedEscaperMap.create(replacementMap), safeMin, safeMax, unsafeReplacement);
    }

    protected ArrayBasedUnicodeEscaper(ArrayBasedEscaperMap escaperMap, int safeMin, int safeMax, @Nullable String unsafeReplacement) {
        Preconditions.checkNotNull(escaperMap);
        this.replacements = escaperMap.getReplacementArray();
        this.replacementsLength = this.replacements.length;
        if (safeMax < safeMin) {
            safeMax = -1;
            safeMin = Integer.MAX_VALUE;
        }
        this.safeMin = safeMin;
        this.safeMax = safeMax;
        if (safeMin >= 55296) {
            this.safeMinChar = (char)65535;
            this.safeMaxChar = '\u0000';
        } else {
            this.safeMinChar = (char)safeMin;
            this.safeMaxChar = (char)Math.min(safeMax, 55295);
        }
    }

    @Override
    public final String escape(String s15) {
        Preconditions.checkNotNull(s15);
        for (int i15 = 0; i15 < s15.length(); ++i15) {
            char c15 = s15.charAt(i15);
            if ((c15 >= this.replacementsLength || this.replacements[c15] == null) && c15 <= this.safeMaxChar && c15 >= this.safeMinChar) continue;
            return this.escapeSlow(s15, i15);
        }
        return s15;
    }

    @Override
    protected final char @Nullable [] escape(int cp4) {
        char[] chars;
        if (cp4 < this.replacementsLength && (chars = this.replacements[cp4]) != null) {
            return chars;
        }
        if (cp4 >= this.safeMin && cp4 <= this.safeMax) {
            return null;
        }
        return this.escapeUnsafe(cp4);
    }

    @Override
    protected final int nextEscapeIndex(CharSequence csq, int index, int end) {
        char c15;
        while (index < end && ((c15 = csq.charAt(index)) >= this.replacementsLength || this.replacements[c15] == null) && c15 <= this.safeMaxChar && c15 >= this.safeMinChar) {
            ++index;
        }
        return index;
    }

    protected abstract char @Nullable [] escapeUnsafe(int var1);
}

