/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.lang;

import com.twelvemonkeys.util.StringTokenIterator;
import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class StringUtil {
    public static final String DELIMITER_STRING = ", \t\n\r\f";

    private StringUtil() {
    }

    public static String decode(byte[] byArray, int n15, int n16, String string) {
        try {
            return new String(byArray, n15, n16, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedCharsetException(string);
        }
    }

    public static String valueOf(Object object) {
        return object != null ? object.toString() : null;
    }

    public static String toUpperCase(String string) {
        if (string != null) {
            return string.toUpperCase();
        }
        return null;
    }

    public static String toLowerCase(String string) {
        if (string != null) {
            return string.toLowerCase();
        }
        return null;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean isEmpty(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (StringUtil.isEmpty(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(String string, String string2) {
        return string != null && string2 != null && string.indexOf(string2) >= 0;
    }

    public static boolean containsIgnoreCase(String string, String string2) {
        return StringUtil.indexOfIgnoreCase(string, string2, 0) >= 0;
    }

    public static boolean contains(String string, int n15) {
        return string != null && string.indexOf(n15) >= 0;
    }

    public static boolean containsIgnoreCase(String string, int n15) {
        return string != null && (string.indexOf(Character.toLowerCase((char)n15)) >= 0 || string.indexOf(Character.toUpperCase((char)n15)) >= 0);
    }

    public static int indexOfIgnoreCase(String string, String string2) {
        return StringUtil.indexOfIgnoreCase(string, string2, 0);
    }

    public static int indexOfIgnoreCase(String string, String string2, int n15) {
        if (string == null || string2 == null) {
            return -1;
        }
        if (string2.length() == 0) {
            return n15;
        }
        if (string2.length() > string.length()) {
            return -1;
        }
        char c15 = Character.toLowerCase(string2.charAt(0));
        char c16 = Character.toUpperCase(string2.charAt(0));
        int n16 = 0;
        int n17 = 0;
        for (int i15 = n15; i15 <= string.length() - string2.length(); ++i15) {
            n16 = n16 >= 0 && n16 <= i15 ? string.indexOf(c15, i15) : n16;
            int n18 = n17 = n17 >= 0 && n17 <= i15 ? string.indexOf(c16, i15) : n17;
            if (n16 < 0) {
                if (n17 < 0) {
                    return -1;
                }
                i15 = n17;
            } else if (n17 < 0) {
                i15 = n16;
            } else {
                int n19 = i15 = n16 < n17 ? n16 : n17;
            }
            if (string2.length() == 1) {
                return i15;
            }
            if (i15 > string.length() - string2.length()) {
                return -1;
            }
            if (string.charAt(i15 + string2.length() - 1) != Character.toLowerCase(string2.charAt(string2.length() - 1)) && string.charAt(i15 + string2.length() - 1) != Character.toUpperCase(string2.charAt(string2.length() - 1)) || string2.length() > 2 && !string.regionMatches(true, i15 + 1, string2, 1, string2.length() - 2)) continue;
            return i15;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(String string, String string2) {
        return StringUtil.lastIndexOfIgnoreCase(string, string2, string != null ? string.length() - 1 : -1);
    }

    public static int lastIndexOfIgnoreCase(String string, String string2, int n15) {
        if (string == null || string2 == null) {
            return -1;
        }
        if (string2.length() == 0) {
            return n15;
        }
        if (string2.length() > string.length()) {
            return -1;
        }
        char c15 = Character.toLowerCase(string2.charAt(0));
        char c16 = Character.toUpperCase(string2.charAt(0));
        int n16 = n15;
        int n17 = n15;
        for (int i15 = n15; i15 >= 0; --i15) {
            n16 = n16 >= 0 && n16 >= i15 ? string.lastIndexOf(c15, i15) : n16;
            int n18 = n17 = n17 >= 0 && n17 >= i15 ? string.lastIndexOf(c16, i15) : n17;
            if (n16 < 0) {
                if (n17 < 0) {
                    return -1;
                }
                i15 = n17;
            } else if (n17 < 0) {
                i15 = n16;
            } else {
                int n19 = i15 = n16 > n17 ? n16 : n17;
            }
            if (string2.length() == 1) {
                return i15;
            }
            if (i15 > string.length() - string2.length() || string.charAt(i15 + string2.length() - 1) != Character.toLowerCase(string2.charAt(string2.length() - 1)) && string.charAt(i15 + string2.length() - 1) != Character.toUpperCase(string2.charAt(string2.length() - 1)) || string2.length() > 2 && !string.regionMatches(true, i15 + 1, string2, 1, string2.length() - 2)) continue;
            return i15;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(String string, int n15) {
        return StringUtil.indexOfIgnoreCase(string, n15, 0);
    }

    public static int indexOfIgnoreCase(String string, int n15, int n16) {
        if (string == null) {
            return -1;
        }
        char c15 = Character.toLowerCase((char)n15);
        char c16 = Character.toUpperCase((char)n15);
        int n17 = string.indexOf(c15, n16);
        int n18 = string.indexOf(c16, n16);
        if (n17 < 0) {
            return n18;
        }
        if (n18 < 0) {
            return n17;
        }
        return n17 < n18 ? n17 : n18;
    }

    public static int lastIndexOfIgnoreCase(String string, int n15) {
        return StringUtil.lastIndexOfIgnoreCase(string, n15, string != null ? string.length() : -1);
    }

    public static int lastIndexOfIgnoreCase(String string, int n15, int n16) {
        if (string == null) {
            return -1;
        }
        char c15 = Character.toLowerCase((char)n15);
        char c16 = Character.toUpperCase((char)n15);
        int n17 = string.lastIndexOf(c15, n16);
        int n18 = string.lastIndexOf(c16, n16);
        if (n17 < 0) {
            return n18;
        }
        if (n18 < 0) {
            return n17;
        }
        return n17 > n18 ? n17 : n18;
    }

    public static String ltrim(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        for (int i15 = 0; i15 < string.length(); ++i15) {
            if (Character.isWhitespace(string.charAt(i15))) continue;
            if (i15 == 0) {
                return string;
            }
            return string.substring(i15);
        }
        return "";
    }

    public static String rtrim(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        for (int i15 = string.length(); i15 > 0; --i15) {
            if (Character.isWhitespace(string.charAt(i15 - 1))) continue;
            if (i15 == string.length()) {
                return string;
            }
            return string.substring(0, i15);
        }
        return "";
    }

    public static String replace(String string, String string2, String string3) {
        int n15;
        if (string2.length() == 0) {
            return string;
        }
        int n16 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n15 = string.indexOf(string2, n16)) != -1) {
            stringBuilder.append(string.substring(n16, n15));
            stringBuilder.append(string3);
            n16 = n15 + string2.length();
        }
        stringBuilder.append(string.substring(n16));
        return stringBuilder.toString();
    }

    public static String replaceIgnoreCase(String string, String string2, String string3) {
        int n15;
        if (string2.length() == 0) {
            return string;
        }
        int n16 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n15 = StringUtil.indexOfIgnoreCase(string, string2, n16)) != -1) {
            stringBuilder.append(string.substring(n16, n15));
            stringBuilder.append(string3);
            n16 = n15 + string2.length();
        }
        stringBuilder.append(string.substring(n16));
        return stringBuilder.toString();
    }

    public static String cut(String string, int n15, String string2) {
        int n16;
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((n16 = string.length()) <= n15) {
            return string;
        }
        n16 = string.lastIndexOf(32, n15 - string2.length());
        return string.substring(0, n16) + string2;
    }

    public static String capitalize(String string, int n15) {
        if (n15 < 0) {
            throw new IndexOutOfBoundsException("Negative index not allowed: " + n15);
        }
        if (string == null || string.length() <= n15) {
            return string;
        }
        if (Character.isUpperCase(string.charAt(n15))) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[n15] = Character.toUpperCase(cArray[n15]);
        return new String(cArray);
    }

    public static String capitalize(String string) {
        return StringUtil.capitalize(string, 0);
    }

    @Deprecated
    static String formatNumber(long l15, int n15) throws IllegalArgumentException {
        StringBuilder stringBuilder = new StringBuilder();
        if ((double)l15 >= Math.pow(10.0, n15)) {
            throw new IllegalArgumentException("The number to format cannot contain more digits than the length argument specifies!");
        }
        for (int i15 = n15; i15 > 1 && (double)l15 < Math.pow(10.0, i15 - 1); --i15) {
            stringBuilder.append('0');
        }
        stringBuilder.append(l15);
        return stringBuilder.toString();
    }

    public static String pad(String string, int n15, String string2, boolean bl4) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Pad string: \"" + string2 + "\"");
        }
        if (string.length() >= n15) {
            return string;
        }
        int n16 = n15 - string.length();
        StringBuilder stringBuilder = new StringBuilder(string2);
        while (stringBuilder.length() < n16) {
            stringBuilder.append((CharSequence)stringBuilder);
        }
        if (stringBuilder.length() > n16) {
            stringBuilder.delete(n16, stringBuilder.length());
        }
        return bl4 ? stringBuilder.append(string).toString() : stringBuilder.insert(0, string).toString();
    }

    public static Date toDate(String string) {
        return StringUtil.toDate(string, DateFormat.getInstance());
    }

    public static Date toDate(String string, String string2) {
        return StringUtil.toDate(string, new SimpleDateFormat(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date toDate(String string, DateFormat dateFormat) {
        try {
            DateFormat dateFormat2 = dateFormat;
            synchronized (dateFormat2) {
                return dateFormat.parse(string);
            }
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException.getMessage() + " at pos " + parseException.getErrorOffset());
        }
    }

    public static Timestamp toTimestamp(String string) {
        return Timestamp.valueOf(string);
    }

    public static String[] toStringArray(String string, String string2) {
        if (StringUtil.isEmpty(string)) {
            return new String[0];
        }
        StringTokenIterator stringTokenIterator = new StringTokenIterator(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenIterator.hasMoreElements()) {
            arrayList.add(stringTokenIterator.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] toStringArray(String string) {
        return StringUtil.toStringArray(string, DELIMITER_STRING);
    }

    public static int[] toIntArray(String string, String string2, int n15) {
        if (StringUtil.isEmpty(string)) {
            return new int[0];
        }
        String[] stringArray = StringUtil.toStringArray(string, string2);
        int[] nArray = new int[stringArray.length];
        for (int i15 = 0; i15 < nArray.length; ++i15) {
            nArray[i15] = Integer.parseInt(stringArray[i15], n15);
        }
        return nArray;
    }

    public static int[] toIntArray(String string) {
        return StringUtil.toIntArray(string, DELIMITER_STRING, 10);
    }

    public static int[] toIntArray(String string, String string2) {
        return StringUtil.toIntArray(string, string2, 10);
    }

    public static long[] toLongArray(String string, String string2) {
        if (StringUtil.isEmpty(string)) {
            return new long[0];
        }
        String[] stringArray = StringUtil.toStringArray(string, string2);
        long[] lArray = new long[stringArray.length];
        for (int i15 = 0; i15 < lArray.length; ++i15) {
            lArray[i15] = Long.parseLong(stringArray[i15]);
        }
        return lArray;
    }

    public static long[] toLongArray(String string) {
        return StringUtil.toLongArray(string, DELIMITER_STRING);
    }

    public static double[] toDoubleArray(String string, String string2) {
        if (StringUtil.isEmpty(string)) {
            return new double[0];
        }
        String[] stringArray = StringUtil.toStringArray(string, string2);
        double[] dArray = new double[stringArray.length];
        for (int i15 = 0; i15 < dArray.length; ++i15) {
            dArray[i15] = Double.valueOf(stringArray[i15]);
        }
        return dArray;
    }

    public static double[] toDoubleArray(String string) {
        return StringUtil.toDoubleArray(string, DELIMITER_STRING);
    }

    public static Color toColor(String string) {
        if (string == null) {
            return null;
        }
        if (string.charAt(0) == '#') {
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            int n18 = -1;
            if (string.length() >= 7) {
                int n19 = 1;
                if (string.length() >= 9) {
                    n18 = Integer.parseInt(string.substring(n19, n19 + 2), 16);
                    n19 += 2;
                }
                n15 = Integer.parseInt(string.substring(n19, n19 + 2), 16);
                n16 = Integer.parseInt(string.substring(n19 + 2, n19 + 4), 16);
                n17 = Integer.parseInt(string.substring(n19 + 4, n19 + 6), 16);
            } else if (string.length() >= 4) {
                int n25 = 1;
                if (string.length() >= 5) {
                    n18 = Integer.parseInt(string.substring(n25++, n25), 16) * 16;
                }
                n15 = Integer.parseInt(string.substring(n25++, n25), 16) * 16;
                n16 = Integer.parseInt(string.substring(n25++, n25), 16) * 16;
                n17 = Integer.parseInt(string.substring(n25++, n25), 16) * 16;
            }
            if (n18 != -1) {
                return new Color(n15, n16, n17, n18);
            }
            return new Color(n15, n16, n17);
        }
        try {
            int n26;
            Class<Color> clazz = Color.class;
            Field field = null;
            try {
                field = clazz.getField(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (field == null) {
                field = clazz.getField(string.toLowerCase());
            }
            if (Modifier.isPublic(n26 = field.getModifiers()) && Modifier.isStatic(n26)) {
                return (Color)field.get(null);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException("No such color: " + string);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public static String toColorString(Color color) {
        if (color == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(Integer.toHexString(color.getRGB()));
        for (int i15 = stringBuilder.length(); i15 < 8; ++i15) {
            stringBuilder.insert(0, '0');
        }
        if (stringBuilder.charAt(0) == 'f' && stringBuilder.charAt(1) == 'f') {
            stringBuilder.delete(0, 2);
        }
        return stringBuilder.insert(0, '#').toString();
    }

    public static boolean isNumber(String string) {
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        char c15 = string.charAt(0);
        if (c15 != '-' && !Character.isDigit(c15)) {
            return false;
        }
        for (int i15 = 1; i15 < string.length(); ++i15) {
            if (Character.isDigit(string.charAt(i15))) continue;
            return false;
        }
        return true;
    }

    static String ensureIncludesAt(String string, String string2, int n15) {
        StringBuilder stringBuilder = new StringBuilder(string);
        try {
            String string3 = string.substring(n15, n15 + string2.length());
            if (!string3.equalsIgnoreCase(string2)) {
                stringBuilder.insert(n15, string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    static String ensureExcludesAt(String string, String string2, int n15) {
        StringBuilder stringBuilder = new StringBuilder(string);
        try {
            String string3 = string.substring(n15 + 1, n15 + string2.length() + 1);
            if (!string3.equalsIgnoreCase(string2)) {
                stringBuilder.delete(n15, n15 + string2.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public static String substring(String string, String string2, String string3, int n15) {
        int n16 = n15 < 0 ? 0 : n15;
        int n17 = string.indexOf(string2, n16) + string2.length();
        if (n17 < 0) {
            return null;
        }
        int n18 = string.indexOf(string3, n17);
        if (n18 < 0) {
            return null;
        }
        return string.substring(n17, n18);
    }

    @Deprecated
    static String removeSubstring(String string, char c15, char c16, int n15) {
        char[] cArray;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl4 = false;
        for (char c17 : cArray = string.toCharArray()) {
            if (!bl4) {
                if (c17 == c15) {
                    bl4 = true;
                    continue;
                }
                stringBuilder.append(c17);
                continue;
            }
            if (c17 != c16) continue;
            bl4 = false;
        }
        return stringBuilder.toString();
    }

    static String removeSubstrings(String string, char c15, char c16) {
        char[] cArray;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl4 = false;
        for (char c17 : cArray = string.toCharArray()) {
            if (!bl4) {
                if (c17 == c15) {
                    bl4 = true;
                    continue;
                }
                stringBuilder.append(c17);
                continue;
            }
            if (c17 != c16) continue;
            bl4 = false;
        }
        return stringBuilder.toString();
    }

    public static String getFirstElement(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("delimiter == null");
        }
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        int n15 = string.indexOf(string2);
        if (n15 >= 0) {
            return string.substring(0, n15);
        }
        return string;
    }

    public static String getLastElement(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("delimiter == null");
        }
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        int n15 = string.lastIndexOf(string2);
        if (n15 >= 0) {
            return string.substring(n15 + 1);
        }
        return string;
    }

    public static String toCSVString(Object[] objectArray) {
        return StringUtil.toCSVString(objectArray, ", ");
    }

    public static String toCSVString(Object[] objectArray, String string) {
        if (objectArray == null) {
            return "";
        }
        if (string == null) {
            throw new IllegalArgumentException("delimiter == null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i15 = 0; i15 < objectArray.length; ++i15) {
            if (i15 > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(objectArray[i15]);
        }
        return stringBuilder.toString();
    }

    public static String deepToString(Object object) {
        return StringUtil.deepToString(object, false, 1);
    }

    public static String deepToString(Object object, boolean bl4, int n15) {
        if (object == null) {
            return null;
        }
        if (!bl4 && !StringUtil.isIdentityToString(object)) {
            return object.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (object.getClass().isArray()) {
            Class<?> clazz = object.getClass();
            while (clazz.isArray()) {
                stringBuilder.append('[');
                stringBuilder.append(Array.getLength(object));
                stringBuilder.append(']');
                clazz = clazz.getComponentType();
            }
            stringBuilder.insert(0, clazz);
            stringBuilder.append(" {hashCode=");
            stringBuilder.append(Integer.toHexString(object.hashCode()));
            stringBuilder.append("}");
        } else {
            Method[] methodArray;
            if (StringUtil.isIdentityToString(object)) {
                stringBuilder.append(" {");
            } else {
                stringBuilder.append(" {toString=");
                stringBuilder.append(object.toString());
                stringBuilder.append(", ");
            }
            stringBuilder.append("hashCode=");
            stringBuilder.append(Integer.toHexString(object.hashCode()));
            for (Method method : methodArray = object.getClass().getMethods()) {
                Class<?>[] classArray;
                if (!Modifier.isPublic(method.getModifiers())) continue;
                String string = method.getName();
                String string2 = null;
                if (!string.equals("getClass") && string.length() > 3 && string.startsWith("get") && Character.isUpperCase(string.charAt(3))) {
                    string2 = string.substring(3);
                } else if (string.length() > 2 && string.startsWith("is") && Character.isUpperCase(string.charAt(2))) {
                    string2 = string.substring(2);
                }
                if (string2 == null) continue;
                if (string2.length() > 1 && Character.isLowerCase(string2.charAt(1))) {
                    string2 = Character.toLowerCase(string2.charAt(0)) + string2.substring(1);
                }
                boolean bl5 = (classArray = method.getParameterTypes()) != null && classArray.length > 0;
                boolean bl6 = Void.TYPE.equals(method.getReturnType());
                if (bl6 || bl5) continue;
                try {
                    Object object2 = method.invoke(object, new Object[0]);
                    stringBuilder.append(", ");
                    stringBuilder.append(string2);
                    stringBuilder.append('=');
                    if (n15 != 0 && object2 != null && StringUtil.isIdentityToString(object2)) {
                        stringBuilder.append(StringUtil.deepToString(object2, bl4, n15 > 0 ? n15 - 1 : -1));
                        continue;
                    }
                    stringBuilder.append(object2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stringBuilder.append('}');
            stringBuilder.insert(0, object.getClass().getName());
        }
        return stringBuilder.toString();
    }

    private static boolean isIdentityToString(Object object) {
        try {
            Method method = object.getClass().getMethod("toString", new Class[0]);
            if (method.getDeclaringClass() == Object.class) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String identityToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
    }

    public boolean matches(String string, String string2) throws PatternSyntaxException {
        return Pattern.matches(string2, string);
    }

    public String replaceFirst(String string, String string2, String string3) {
        return Pattern.compile(string2).matcher(string).replaceFirst(string3);
    }

    public String replaceAll(String string, String string2, String string3) {
        return Pattern.compile(string2).matcher(string).replaceAll(string3);
    }

    public String[] split(String string, String string2, int n15) {
        return Pattern.compile(string2).split(string, n15);
    }

    public String[] split(String string, String string2) {
        return this.split(string, string2, 0);
    }

    public static String camelToLisp(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (string.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = null;
        int n15 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        for (int i15 = 1; i15 < string.length(); ++i15) {
            char c15;
            char c16 = string.charAt(i15);
            if (Character.isUpperCase(c16)) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string.length() + 3);
                }
                if (bl5) {
                    bl5 = false;
                    stringBuilder.append(string.substring(n15, i15));
                    if (c16 != '-') {
                        stringBuilder.append('-');
                    }
                    n15 = i15;
                    continue;
                }
                c15 = string.charAt(i15 - 1);
                if (i15 == n15 || Character.isUpperCase(c15)) {
                    bl4 = true;
                    continue;
                }
                stringBuilder.append(string.substring(n15, i15).toLowerCase());
                if (c15 != '-') {
                    stringBuilder.append('-');
                }
                stringBuilder.append(Character.toLowerCase(c16));
                n15 = i15 + 1;
                continue;
            }
            if (Character.isDigit(c16)) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string.length() + 3);
                }
                if (bl4) {
                    bl4 = false;
                    stringBuilder.append(string.substring(n15, i15).toLowerCase());
                    if (c16 != '-') {
                        stringBuilder.append('-');
                    }
                    n15 = i15;
                    continue;
                }
                c15 = string.charAt(i15 - 1);
                if (i15 == n15 || Character.isDigit(c15)) {
                    bl5 = true;
                    continue;
                }
                stringBuilder.append(string.substring(n15, i15).toLowerCase());
                if (c15 != '-') {
                    stringBuilder.append('-');
                }
                stringBuilder.append(Character.toLowerCase(c16));
                n15 = i15 + 1;
                continue;
            }
            if (bl5) {
                bl5 = false;
                stringBuilder.append(string.substring(n15, i15));
                if (c16 != '-') {
                    stringBuilder.append('-');
                }
                n15 = i15;
                continue;
            }
            if (!bl4) continue;
            bl4 = false;
            stringBuilder.append(string.substring(n15, i15 - 1).toLowerCase());
            if (c16 != '-') {
                stringBuilder.append('-');
            }
            n15 = i15 - 1;
        }
        if (stringBuilder != null) {
            stringBuilder.append(string.substring(n15).toLowerCase());
            return stringBuilder.toString();
        }
        return Character.isUpperCase(string.charAt(0)) ? string.toLowerCase() : string;
    }

    public static String lispToCamel(String string) {
        return StringUtil.lispToCamel(string, false);
    }

    public static String lispToCamel(String string, boolean bl4) {
        if (string == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (string.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = null;
        int n15 = 0;
        for (int i15 = 0; i15 < string.length(); ++i15) {
            char c15 = string.charAt(i15);
            if (c15 != '-') continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(string.length() - 1);
            }
            if (n15 != 0 || bl4) {
                stringBuilder.append(Character.toUpperCase(string.charAt(n15)));
                ++n15;
            }
            stringBuilder.append(string.substring(n15, i15).toLowerCase());
            n15 = i15 + 1;
        }
        if (stringBuilder != null) {
            stringBuilder.append(Character.toUpperCase(string.charAt(n15)));
            stringBuilder.append(string.substring(n15 + 1).toLowerCase());
            return stringBuilder.toString();
        }
        if (bl4 && !Character.isUpperCase(string.charAt(0))) {
            return StringUtil.capitalize(string, 0);
        }
        if (!bl4 && Character.isUpperCase(string.charAt(0))) {
            return Character.toLowerCase(string.charAt(0)) + string.substring(1);
        }
        return string;
    }

    public static String reverse(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        for (int i15 = 0; i15 < cArray.length / 2; ++i15) {
            char c15 = cArray[i15];
            cArray[i15] = cArray[cArray.length - 1 - i15];
            cArray[cArray.length - 1 - i15] = c15;
        }
        return new String(cArray);
    }
}

