/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelCollector<T, A, R>
extends Flowable<R> {
    final ParallelFlowable<? extends T> source;
    final Collector<T, A, R> collector;

    public ParallelCollector(ParallelFlowable<? extends T> source, Collector<T, A, R> collector) {
        this.source = source;
        this.collector = collector;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s15) {
        ParallelCollectorSubscriber<T, A, ? super R> parent;
        try {
            parent = new ParallelCollectorSubscriber<T, A, R>(s15, this.source.parallelism(), this.collector);
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            EmptySubscription.error(ex4, s15);
            return;
        }
        s15.onSubscribe(parent);
        this.source.subscribe(parent.subscribers);
    }

    static final class SlotPair<T>
    extends AtomicInteger {
        private static final long serialVersionUID = 473971317683868662L;
        T first;
        T second;
        final AtomicInteger releaseIndex = new AtomicInteger();

        SlotPair() {
        }

        int tryAcquireSlot() {
            int acquired;
            do {
                if ((acquired = this.get()) < 2) continue;
                return -1;
            } while (!this.compareAndSet(acquired, acquired + 1));
            return acquired;
        }

        boolean releaseSlot() {
            return this.releaseIndex.incrementAndGet() == 2;
        }
    }

    static final class ParallelCollectorInnerSubscriber<T, A, R>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -7954444275102466525L;
        final ParallelCollectorSubscriber<T, A, R> parent;
        final BiConsumer<A, T> accumulator;
        final BinaryOperator<A> combiner;
        A container;
        boolean done;

        ParallelCollectorInnerSubscriber(ParallelCollectorSubscriber<T, A, R> parent, A container, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner) {
            this.parent = parent;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.container = container;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            SubscriptionHelper.setOnce(this, s15, Long.MAX_VALUE);
        }

        @Override
        public void onNext(T t15) {
            if (!this.done) {
                try {
                    this.accumulator.accept(this.container, t15);
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    ((Subscription)this.get()).cancel();
                    this.onError(ex4);
                }
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.container = null;
            this.done = true;
            this.parent.innerError(t15);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                A v15 = this.container;
                this.container = null;
                this.done = true;
                this.parent.innerComplete(v15, this.combiner);
            }
        }

        void cancel() {
            SubscriptionHelper.cancel(this);
        }
    }

    static final class ParallelCollectorSubscriber<T, A, R>
    extends DeferredScalarSubscription<R> {
        private static final long serialVersionUID = -5370107872170712765L;
        final ParallelCollectorInnerSubscriber<T, A, R>[] subscribers;
        final AtomicReference<SlotPair<A>> current = new AtomicReference();
        final AtomicInteger remaining = new AtomicInteger();
        final AtomicThrowable error = new AtomicThrowable();
        final Function<A, R> finisher;

        ParallelCollectorSubscriber(Subscriber<? super R> subscriber, int n15, Collector<T, A, R> collector) {
            super(subscriber);
            this.finisher = collector.finisher();
            ParallelCollectorInnerSubscriber[] a15 = new ParallelCollectorInnerSubscriber[n15];
            for (int i15 = 0; i15 < n15; ++i15) {
                a15[i15] = new ParallelCollectorInnerSubscriber(this, collector.supplier().get(), collector.accumulator(), collector.combiner());
            }
            this.subscribers = a15;
            this.remaining.lazySet(n15);
        }

        SlotPair<A> addValue(A value) {
            int c15;
            SlotPair<Object> curr;
            while (true) {
                if ((curr = this.current.get()) == null && !this.current.compareAndSet(null, curr = new SlotPair())) {
                    continue;
                }
                c15 = curr.tryAcquireSlot();
                if (c15 >= 0) break;
                this.current.compareAndSet(curr, null);
            }
            if (c15 == 0) {
                curr.first = value;
            } else {
                curr.second = value;
            }
            if (curr.releaseSlot()) {
                this.current.compareAndSet(curr, null);
                return curr;
            }
            return null;
        }

        @Override
        public void cancel() {
            for (ParallelCollectorInnerSubscriber<T, A, R> inner : this.subscribers) {
                inner.cancel();
            }
        }

        void innerError(Throwable ex4) {
            if (this.error.compareAndSet(null, ex4)) {
                this.cancel();
                this.downstream.onError(ex4);
            } else if (ex4 != this.error.get()) {
                RxJavaPlugins.onError(ex4);
            }
        }

        void innerComplete(A value, BinaryOperator<A> combiner) {
            SlotPair<A> sp4;
            while ((sp4 = this.addValue(value)) != null) {
                try {
                    value = combiner.apply(sp4.first, sp4.second);
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.innerError(ex4);
                    return;
                }
            }
            if (this.remaining.decrementAndGet() == 0) {
                R result;
                sp4 = this.current.get();
                this.current.lazySet(null);
                try {
                    result = Objects.requireNonNull(this.finisher.apply(sp4.first), "The finisher returned a null value");
                }
                catch (Throwable ex5) {
                    Exceptions.throwIfFatal(ex5);
                    this.innerError(ex5);
                    return;
                }
                this.complete(result);
            }
        }
    }
}

