/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.util.BlockingHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public final class FutureMultiObserver<T>
extends CountDownLatch
implements MaybeObserver<T>,
SingleObserver<T>,
CompletableObserver,
Future<T>,
Disposable {
    T value;
    Throwable error;
    final AtomicReference<Disposable> upstream = new AtomicReference();

    public FutureMultiObserver() {
        super(1);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Disposable a15;
        do {
            if ((a15 = this.upstream.get()) != this && a15 != DisposableHelper.DISPOSED) continue;
            return false;
        } while (!this.upstream.compareAndSet(a15, DisposableHelper.DISPOSED));
        if (a15 != null) {
            a15.dispose();
        }
        this.countDown();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return DisposableHelper.isDisposed(this.upstream.get());
    }

    @Override
    public boolean isDone() {
        return this.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        if (this.getCount() != 0L) {
            BlockingHelper.verifyNonBlocking();
            this.await();
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable ex4 = this.error;
        if (ex4 != null) {
            throw new ExecutionException(ex4);
        }
        return this.value;
    }

    @Override
    public T get(long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.getCount() != 0L) {
            BlockingHelper.verifyNonBlocking();
            if (!this.await(timeout, unit)) {
                throw new TimeoutException(ExceptionHelper.timeoutMessage(timeout, unit));
            }
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable ex4 = this.error;
        if (ex4 != null) {
            throw new ExecutionException(ex4);
        }
        return this.value;
    }

    @Override
    public void onSubscribe(Disposable d15) {
        DisposableHelper.setOnce(this.upstream, d15);
    }

    @Override
    public void onSuccess(T t15) {
        Disposable a15 = this.upstream.get();
        if (a15 == DisposableHelper.DISPOSED) {
            return;
        }
        this.value = t15;
        this.upstream.compareAndSet(a15, this);
        this.countDown();
    }

    @Override
    public void onError(Throwable t15) {
        Disposable a15;
        do {
            if ((a15 = this.upstream.get()) == DisposableHelper.DISPOSED) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.error = t15;
        } while (!this.upstream.compareAndSet(a15, this));
        this.countDown();
    }

    @Override
    public void onComplete() {
        Disposable a15 = this.upstream.get();
        if (a15 == DisposableHelper.DISPOSED) {
            return;
        }
        this.upstream.compareAndSet(a15, this);
        this.countDown();
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isDisposed() {
        return this.isDone();
    }
}

