/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscribers.InnerQueuedSubscriber;
import io.reactivex.rxjava3.internal.subscribers.InnerQueuedSubscriberSupport;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableConcatMapEager<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final int maxConcurrency;
    final int prefetch;
    final ErrorMode errorMode;

    public FlowableConcatMapEager(Flowable<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int prefetch, ErrorMode errorMode) {
        super(source);
        this.mapper = mapper;
        this.maxConcurrency = maxConcurrency;
        this.prefetch = prefetch;
        this.errorMode = errorMode;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s15) {
        this.source.subscribe(new ConcatMapEagerDelayErrorSubscriber<T, R>(s15, this.mapper, this.maxConcurrency, this.prefetch, this.errorMode));
    }

    static final class ConcatMapEagerDelayErrorSubscriber<T, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    InnerQueuedSubscriberSupport<R> {
        private static final long serialVersionUID = -4255299542215038287L;
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final int maxConcurrency;
        final int prefetch;
        final ErrorMode errorMode;
        final AtomicThrowable errors;
        final AtomicLong requested;
        final SpscLinkedArrayQueue<InnerQueuedSubscriber<R>> subscribers;
        Subscription upstream;
        volatile boolean cancelled;
        volatile boolean done;
        volatile InnerQueuedSubscriber<R> current;

        ConcatMapEagerDelayErrorSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int prefetch, ErrorMode errorMode) {
            this.downstream = actual;
            this.mapper = mapper;
            this.maxConcurrency = maxConcurrency;
            this.prefetch = prefetch;
            this.errorMode = errorMode;
            this.subscribers = new SpscLinkedArrayQueue(Math.min(prefetch, maxConcurrency));
            this.errors = new AtomicThrowable();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                s15.request(this.maxConcurrency == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)this.maxConcurrency);
            }
        }

        @Override
        public void onNext(T t15) {
            Publisher<R> p15;
            try {
                p15 = Objects.requireNonNull(this.mapper.apply(t15), "The mapper returned a null Publisher");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.upstream.cancel();
                this.onError(ex4);
                return;
            }
            InnerQueuedSubscriber inner = new InnerQueuedSubscriber(this, this.prefetch);
            if (this.cancelled) {
                return;
            }
            this.subscribers.offer(inner);
            p15.subscribe(inner);
            if (this.cancelled) {
                inner.cancel();
                this.drainAndCancel();
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.errors.tryAddThrowableOrReport(t15)) {
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.upstream.cancel();
            this.errors.tryTerminateAndReport();
            this.drainAndCancel();
        }

        void drainAndCancel() {
            if (this.getAndIncrement() == 0) {
                do {
                    this.cancelAll();
                } while (this.decrementAndGet() != 0);
            }
        }

        void cancelAll() {
            InnerQueuedSubscriber<R> inner = this.current;
            this.current = null;
            if (inner != null) {
                inner.cancel();
            }
            while ((inner = this.subscribers.poll()) != null) {
                inner.cancel();
            }
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.drain();
            }
        }

        @Override
        public void innerNext(InnerQueuedSubscriber<R> inner, R value) {
            if (inner.queue().offer(value)) {
                this.drain();
            } else {
                inner.cancel();
                this.innerError(inner, (Throwable)MissingBackpressureException.createDefault());
            }
        }

        @Override
        public void innerError(InnerQueuedSubscriber<R> inner, Throwable e15) {
            if (this.errors.tryAddThrowableOrReport(e15)) {
                inner.setDone();
                if (this.errorMode != ErrorMode.END) {
                    this.upstream.cancel();
                }
                this.drain();
            }
        }

        @Override
        public void innerComplete(InnerQueuedSubscriber<R> inner) {
            inner.setDone();
            this.drain();
        }

        @Override
        public void drain() {
            boolean continueNextSource;
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            InnerQueuedSubscriber<R> inner = this.current;
            Subscriber<R> a15 = this.downstream;
            ErrorMode em4 = this.errorMode;
            do {
                SimpleQueue<R> q15;
                long r15 = this.requested.get();
                long e15 = 0L;
                if (inner == null) {
                    Throwable ex4;
                    if (em4 != ErrorMode.END && (ex4 = (Throwable)this.errors.get()) != null) {
                        this.cancelAll();
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    boolean outerDone = this.done;
                    inner = this.subscribers.poll();
                    if (outerDone && inner == null) {
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    if (inner != null) {
                        this.current = inner;
                    }
                }
                continueNextSource = false;
                if (inner != null && (q15 = inner.queue()) != null) {
                    boolean d15;
                    while (e15 != r15) {
                        boolean empty;
                        R v15;
                        Throwable ex5;
                        if (this.cancelled) {
                            this.cancelAll();
                            return;
                        }
                        if (em4 == ErrorMode.IMMEDIATE && (ex5 = (Throwable)this.errors.get()) != null) {
                            this.current = null;
                            inner.cancel();
                            this.cancelAll();
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        d15 = inner.isDone();
                        try {
                            v15 = q15.poll();
                        }
                        catch (Throwable ex6) {
                            Exceptions.throwIfFatal(ex6);
                            this.current = null;
                            inner.cancel();
                            this.cancelAll();
                            a15.onError(ex6);
                            return;
                        }
                        boolean bl4 = empty = v15 == null;
                        if (d15 && empty) {
                            inner = null;
                            this.current = null;
                            this.upstream.request(1L);
                            continueNextSource = true;
                            break;
                        }
                        if (empty) break;
                        a15.onNext(v15);
                        ++e15;
                        inner.request(1L);
                    }
                    if (e15 == r15) {
                        Throwable ex7;
                        if (this.cancelled) {
                            this.cancelAll();
                            return;
                        }
                        if (em4 == ErrorMode.IMMEDIATE && (ex7 = (Throwable)this.errors.get()) != null) {
                            this.current = null;
                            inner.cancel();
                            this.cancelAll();
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        d15 = inner.isDone();
                        boolean empty = q15.isEmpty();
                        if (d15 && empty) {
                            inner = null;
                            this.current = null;
                            this.upstream.request(1L);
                            continueNextSource = true;
                        }
                    }
                }
                if (e15 == 0L || r15 == Long.MAX_VALUE) continue;
                this.requested.addAndGet(-e15);
            } while (continueNextSource || (missed = this.addAndGet(-missed)) != 0);
        }
    }
}

