/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;

public final class MaybeFromCallable<T>
extends Maybe<T>
implements Supplier<T> {
    final Callable<? extends T> callable;

    public MaybeFromCallable(Callable<? extends T> callable) {
        this.callable = callable;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        Disposable d15 = Disposable.empty();
        observer.onSubscribe(d15);
        if (!d15.isDisposed()) {
            T v15;
            try {
                v15 = this.callable.call();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                if (!d15.isDisposed()) {
                    observer.onError(ex4);
                } else {
                    RxJavaPlugins.onError(ex4);
                }
                return;
            }
            if (!d15.isDisposed()) {
                if (v15 == null) {
                    observer.onComplete();
                } else {
                    observer.onSuccess(v15);
                }
            }
        }
    }

    @Override
    public T get() throws Exception {
        return this.callable.call();
    }
}

