/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.observers.QueueDrainObserver;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import io.reactivex.rxjava3.internal.util.QueueDrainHelper;
import io.reactivex.rxjava3.observers.DisposableObserver;
import io.reactivex.rxjava3.observers.SerializedObserver;
import java.util.Collection;
import java.util.Objects;

public final class ObservableBufferExactBoundary<T, U extends Collection<? super T>, B>
extends AbstractObservableWithUpstream<T, U> {
    final ObservableSource<B> boundary;
    final Supplier<U> bufferSupplier;

    public ObservableBufferExactBoundary(ObservableSource<T> source, ObservableSource<B> boundary, Supplier<U> bufferSupplier) {
        super(source);
        this.boundary = boundary;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Observer<? super U> t15) {
        this.source.subscribe(new BufferExactBoundaryObserver(new SerializedObserver<U>(t15), this.bufferSupplier, this.boundary));
    }

    static final class BufferBoundaryObserver<T, U extends Collection<? super T>, B>
    extends DisposableObserver<B> {
        final BufferExactBoundaryObserver<T, U, B> parent;

        BufferBoundaryObserver(BufferExactBoundaryObserver<T, U, B> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t15) {
            this.parent.next();
        }

        @Override
        public void onError(Throwable t15) {
            this.parent.onError(t15);
        }

        @Override
        public void onComplete() {
            this.parent.onComplete();
        }
    }

    static final class BufferExactBoundaryObserver<T, U extends Collection<? super T>, B>
    extends QueueDrainObserver<T, U, U>
    implements Disposable {
        final Supplier<U> bufferSupplier;
        final ObservableSource<B> boundary;
        Disposable upstream;
        Disposable other;
        U buffer;

        BufferExactBoundaryObserver(Observer<? super U> actual, Supplier<U> bufferSupplier, ObservableSource<B> boundary) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.boundary = boundary;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                BufferBoundaryObserver bs4;
                Collection b15;
                this.upstream = d15;
                try {
                    b15 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The buffer supplied is null");
                }
                catch (Throwable e15) {
                    Exceptions.throwIfFatal(e15);
                    this.cancelled = true;
                    d15.dispose();
                    EmptyDisposable.error(e15, this.downstream);
                    return;
                }
                this.buffer = b15;
                this.other = bs4 = new BufferBoundaryObserver(this);
                this.downstream.onSubscribe(this);
                if (!this.cancelled) {
                    this.boundary.subscribe(bs4);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t15) {
            BufferExactBoundaryObserver bufferExactBoundaryObserver = this;
            synchronized (bufferExactBoundaryObserver) {
                U b15 = this.buffer;
                if (b15 == null) {
                    return;
                }
                b15.add(t15);
            }
        }

        @Override
        public void onError(Throwable t15) {
            this.dispose();
            this.downstream.onError(t15);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            U b15;
            BufferExactBoundaryObserver bufferExactBoundaryObserver = this;
            synchronized (bufferExactBoundaryObserver) {
                b15 = this.buffer;
                if (b15 == null) {
                    return;
                }
                this.buffer = null;
            }
            this.queue.offer(b15);
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainLoop(this.queue, this.downstream, false, this, this);
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.other.dispose();
                this.upstream.dispose();
                if (this.enter()) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void next() {
            U b15;
            Collection next;
            try {
                next = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The buffer supplied is null");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.dispose();
                this.downstream.onError(e15);
                return;
            }
            BufferExactBoundaryObserver bufferExactBoundaryObserver = this;
            synchronized (bufferExactBoundaryObserver) {
                b15 = this.buffer;
                if (b15 == null) {
                    return;
                }
                this.buffer = next;
            }
            this.fastPathEmit(b15, false, this);
        }

        @Override
        public void accept(Observer<? super U> a15, U v15) {
            this.downstream.onNext(v15);
        }
    }
}

