/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.observers.SerializedObserver;
import io.reactivex.rxjava3.operators.QueueDisposable;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableConcatMapScheduler<T, U>
extends AbstractObservableWithUpstream<T, U> {
    final Function<? super T, ? extends ObservableSource<? extends U>> mapper;
    final int bufferSize;
    final ErrorMode delayErrors;
    final Scheduler scheduler;

    public ObservableConcatMapScheduler(ObservableSource<T> source, Function<? super T, ? extends ObservableSource<? extends U>> mapper, int bufferSize, ErrorMode delayErrors, Scheduler scheduler) {
        super(source);
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.bufferSize = Math.max(8, bufferSize);
        this.scheduler = scheduler;
    }

    @Override
    public void subscribeActual(Observer<? super U> observer) {
        if (this.delayErrors == ErrorMode.IMMEDIATE) {
            SerializedObserver<? super U> serial = new SerializedObserver<U>(observer);
            this.source.subscribe(new ConcatMapObserver<T, U>(serial, this.mapper, this.bufferSize, this.scheduler.createWorker()));
        } else {
            this.source.subscribe(new ConcatMapDelayErrorObserver<T, U>(observer, this.mapper, this.bufferSize, this.delayErrors == ErrorMode.END, this.scheduler.createWorker()));
        }
    }

    static final class ConcatMapDelayErrorObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = -6951100001833242599L;
        final Observer<? super R> downstream;
        final Function<? super T, ? extends ObservableSource<? extends R>> mapper;
        final int bufferSize;
        final AtomicThrowable errors;
        final DelayErrorInnerObserver<R> observer;
        final boolean tillTheEnd;
        final Scheduler.Worker worker;
        SimpleQueue<T> queue;
        Disposable upstream;
        volatile boolean active;
        volatile boolean done;
        volatile boolean cancelled;
        int sourceMode;

        ConcatMapDelayErrorObserver(Observer<? super R> actual, Function<? super T, ? extends ObservableSource<? extends R>> mapper, int bufferSize, boolean tillTheEnd, Scheduler.Worker worker) {
            this.downstream = actual;
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.tillTheEnd = tillTheEnd;
            this.errors = new AtomicThrowable();
            this.observer = new DelayErrorInnerObserver<R>(actual, this);
            this.worker = worker;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                if (d15 instanceof QueueDisposable) {
                    QueueDisposable qd5 = (QueueDisposable)d15;
                    int m15 = qd5.requestFusion(3);
                    if (m15 == 1) {
                        this.sourceMode = m15;
                        this.queue = qd5;
                        this.done = true;
                        this.downstream.onSubscribe(this);
                        this.drain();
                        return;
                    }
                    if (m15 == 2) {
                        this.sourceMode = m15;
                        this.queue = qd5;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                }
                this.queue = new SpscLinkedArrayQueue(this.bufferSize);
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T value) {
            if (this.sourceMode == 0) {
                this.queue.offer(value);
            }
            this.drain();
        }

        @Override
        public void onError(Throwable e15) {
            if (this.errors.tryAddThrowableOrReport(e15)) {
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.upstream.dispose();
            this.observer.dispose();
            this.worker.dispose();
            this.errors.tryTerminateAndReport();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            this.worker.schedule(this);
        }

        @Override
        public void run() {
            Observer<R> downstream = this.downstream;
            SimpleQueue<T> queue = this.queue;
            AtomicThrowable errors = this.errors;
            while (true) {
                if (!this.active) {
                    boolean empty;
                    T v15;
                    Throwable ex4;
                    if (this.cancelled) {
                        queue.clear();
                        return;
                    }
                    if (!this.tillTheEnd && (ex4 = (Throwable)errors.get()) != null) {
                        queue.clear();
                        this.cancelled = true;
                        errors.tryTerminateConsumer(downstream);
                        this.worker.dispose();
                        return;
                    }
                    boolean d15 = this.done;
                    try {
                        v15 = queue.poll();
                    }
                    catch (Throwable ex5) {
                        Exceptions.throwIfFatal(ex5);
                        this.cancelled = true;
                        this.upstream.dispose();
                        errors.tryAddThrowableOrReport(ex5);
                        errors.tryTerminateConsumer(downstream);
                        this.worker.dispose();
                        return;
                    }
                    boolean bl4 = empty = v15 == null;
                    if (d15 && empty) {
                        this.cancelled = true;
                        errors.tryTerminateConsumer(downstream);
                        this.worker.dispose();
                        return;
                    }
                    if (!empty) {
                        ObservableSource<R> o15;
                        try {
                            o15 = Objects.requireNonNull(this.mapper.apply(v15), "The mapper returned a null ObservableSource");
                        }
                        catch (Throwable ex6) {
                            Exceptions.throwIfFatal(ex6);
                            this.cancelled = true;
                            this.upstream.dispose();
                            queue.clear();
                            errors.tryAddThrowableOrReport(ex6);
                            errors.tryTerminateConsumer(downstream);
                            this.worker.dispose();
                            return;
                        }
                        if (o15 instanceof Supplier) {
                            Object w15;
                            try {
                                w15 = ((Supplier)((Object)o15)).get();
                            }
                            catch (Throwable ex7) {
                                Exceptions.throwIfFatal(ex7);
                                errors.tryAddThrowableOrReport(ex7);
                                continue;
                            }
                            if (w15 == null || this.cancelled) continue;
                            downstream.onNext(w15);
                            continue;
                        }
                        this.active = true;
                        o15.subscribe(this.observer);
                    }
                }
                if (this.decrementAndGet() == 0) break;
            }
        }

        static final class DelayErrorInnerObserver<R>
        extends AtomicReference<Disposable>
        implements Observer<R> {
            private static final long serialVersionUID = 2620149119579502636L;
            final Observer<? super R> downstream;
            final ConcatMapDelayErrorObserver<?, R> parent;

            DelayErrorInnerObserver(Observer<? super R> actual, ConcatMapDelayErrorObserver<?, R> parent) {
                this.downstream = actual;
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d15) {
                DisposableHelper.replace(this, d15);
            }

            @Override
            public void onNext(R value) {
                this.downstream.onNext(value);
            }

            @Override
            public void onError(Throwable e15) {
                ConcatMapDelayErrorObserver<?, R> p15 = this.parent;
                if (p15.errors.tryAddThrowableOrReport(e15)) {
                    if (!p15.tillTheEnd) {
                        p15.upstream.dispose();
                    }
                    p15.active = false;
                    p15.drain();
                }
            }

            @Override
            public void onComplete() {
                ConcatMapDelayErrorObserver<?, R> p15 = this.parent;
                p15.active = false;
                p15.drain();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }

    static final class ConcatMapObserver<T, U>
    extends AtomicInteger
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = 8828587559905699186L;
        final Observer<? super U> downstream;
        final Function<? super T, ? extends ObservableSource<? extends U>> mapper;
        final InnerObserver<U> inner;
        final int bufferSize;
        final Scheduler.Worker worker;
        SimpleQueue<T> queue;
        Disposable upstream;
        volatile boolean active;
        volatile boolean disposed;
        volatile boolean done;
        int fusionMode;

        ConcatMapObserver(Observer<? super U> actual, Function<? super T, ? extends ObservableSource<? extends U>> mapper, int bufferSize, Scheduler.Worker worker) {
            this.downstream = actual;
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.inner = new InnerObserver<U>(actual, this);
            this.worker = worker;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                if (d15 instanceof QueueDisposable) {
                    QueueDisposable qd5 = (QueueDisposable)d15;
                    int m15 = qd5.requestFusion(3);
                    if (m15 == 1) {
                        this.fusionMode = m15;
                        this.queue = qd5;
                        this.done = true;
                        this.downstream.onSubscribe(this);
                        this.drain();
                        return;
                    }
                    if (m15 == 2) {
                        this.fusionMode = m15;
                        this.queue = qd5;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                }
                this.queue = new SpscLinkedArrayQueue(this.bufferSize);
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            if (this.done) {
                return;
            }
            if (this.fusionMode == 0) {
                this.queue.offer(t15);
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.dispose();
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void innerComplete() {
            this.active = false;
            this.drain();
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.inner.dispose();
            this.upstream.dispose();
            this.worker.dispose();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            this.worker.schedule(this);
        }

        @Override
        public void run() {
            do {
                ObservableSource<U> o15;
                boolean empty;
                T t15;
                if (this.disposed) {
                    this.queue.clear();
                    return;
                }
                if (this.active) continue;
                boolean d15 = this.done;
                try {
                    t15 = this.queue.poll();
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.dispose();
                    this.queue.clear();
                    this.downstream.onError(ex4);
                    this.worker.dispose();
                    return;
                }
                boolean bl4 = empty = t15 == null;
                if (d15 && empty) {
                    this.disposed = true;
                    this.downstream.onComplete();
                    this.worker.dispose();
                    return;
                }
                if (empty) continue;
                try {
                    o15 = Objects.requireNonNull(this.mapper.apply(t15), "The mapper returned a null ObservableSource");
                }
                catch (Throwable ex5) {
                    Exceptions.throwIfFatal(ex5);
                    this.dispose();
                    this.queue.clear();
                    this.downstream.onError(ex5);
                    this.worker.dispose();
                    return;
                }
                this.active = true;
                o15.subscribe(this.inner);
            } while (this.decrementAndGet() != 0);
        }

        static final class InnerObserver<U>
        extends AtomicReference<Disposable>
        implements Observer<U> {
            private static final long serialVersionUID = -7449079488798789337L;
            final Observer<? super U> downstream;
            final ConcatMapObserver<?, ?> parent;

            InnerObserver(Observer<? super U> actual, ConcatMapObserver<?, ?> parent) {
                this.downstream = actual;
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d15) {
                DisposableHelper.replace(this, d15);
            }

            @Override
            public void onNext(U t15) {
                this.downstream.onNext(t15);
            }

            @Override
            public void onError(Throwable t15) {
                this.parent.dispose();
                this.downstream.onError(t15);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

