/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.Objects;

public final class ObservableFlattenIterable<T, R>
extends AbstractObservableWithUpstream<T, R> {
    final Function<? super T, ? extends Iterable<? extends R>> mapper;

    public ObservableFlattenIterable(ObservableSource<T> source, Function<? super T, ? extends Iterable<? extends R>> mapper) {
        super(source);
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        this.source.subscribe(new FlattenIterableObserver<T, R>(observer, this.mapper));
    }

    static final class FlattenIterableObserver<T, R>
    implements Observer<T>,
    Disposable {
        final Observer<? super R> downstream;
        final Function<? super T, ? extends Iterable<? extends R>> mapper;
        Disposable upstream;

        FlattenIterableObserver(Observer<? super R> actual, Function<? super T, ? extends Iterable<? extends R>> mapper) {
            this.downstream = actual;
            this.mapper = mapper;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T value) {
            Iterator<R> it;
            if (this.upstream == DisposableHelper.DISPOSED) {
                return;
            }
            try {
                it = this.mapper.apply(value).iterator();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.upstream.dispose();
                this.onError(ex4);
                return;
            }
            Observer<R> a15 = this.downstream;
            while (true) {
                R v15;
                boolean b15;
                try {
                    b15 = it.hasNext();
                }
                catch (Throwable ex5) {
                    Exceptions.throwIfFatal(ex5);
                    this.upstream.dispose();
                    this.onError(ex5);
                    return;
                }
                if (!b15) break;
                try {
                    v15 = Objects.requireNonNull(it.next(), "The iterator returned a null value");
                }
                catch (Throwable ex6) {
                    Exceptions.throwIfFatal(ex6);
                    this.upstream.dispose();
                    this.onError(ex6);
                    return;
                }
                a15.onNext(v15);
            }
        }

        @Override
        public void onError(Throwable e15) {
            if (this.upstream == DisposableHelper.DISPOSED) {
                RxJavaPlugins.onError(e15);
                return;
            }
            this.upstream = DisposableHelper.DISPOSED;
            this.downstream.onError(e15);
        }

        @Override
        public void onComplete() {
            if (this.upstream == DisposableHelper.DISPOSED) {
                return;
            }
            this.upstream = DisposableHelper.DISPOSED;
            this.downstream.onComplete();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
            this.upstream = DisposableHelper.DISPOSED;
        }
    }
}

