/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;

public final class SingleOnErrorReturn<T>
extends Single<T> {
    final SingleSource<? extends T> source;
    final Function<? super Throwable, ? extends T> valueSupplier;
    final T value;

    public SingleOnErrorReturn(SingleSource<? extends T> source, Function<? super Throwable, ? extends T> valueSupplier, T value) {
        this.source = source;
        this.valueSupplier = valueSupplier;
        this.value = value;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        this.source.subscribe(new OnErrorReturn(observer));
    }

    final class OnErrorReturn
    implements SingleObserver<T> {
        private final SingleObserver<? super T> observer;

        OnErrorReturn(SingleObserver<? super T> observer) {
            this.observer = observer;
        }

        @Override
        public void onError(Throwable e15) {
            Object v15;
            if (SingleOnErrorReturn.this.valueSupplier != null) {
                try {
                    v15 = SingleOnErrorReturn.this.valueSupplier.apply(e15);
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.observer.onError(new CompositeException(e15, ex4));
                    return;
                }
            } else {
                v15 = SingleOnErrorReturn.this.value;
            }
            if (v15 == null) {
                NullPointerException npe = new NullPointerException("Value supplied was null");
                npe.initCause(e15);
                this.observer.onError(npe);
                return;
            }
            this.observer.onSuccess(v15);
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.observer.onSubscribe(d15);
        }

        @Override
        public void onSuccess(T value) {
            this.observer.onSuccess(value);
        }
    }
}

