/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscribers;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.subscribers.InnerQueuedSubscriberSupport;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.QueueDrainHelper;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimpleQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public final class InnerQueuedSubscriber<T>
extends AtomicReference<Subscription>
implements FlowableSubscriber<T>,
Subscription {
    private static final long serialVersionUID = 22876611072430776L;
    final InnerQueuedSubscriberSupport<T> parent;
    final int prefetch;
    final int limit;
    volatile SimpleQueue<T> queue;
    volatile boolean done;
    long produced;
    int fusionMode;

    public InnerQueuedSubscriber(InnerQueuedSubscriberSupport<T> parent, int prefetch) {
        this.parent = parent;
        this.prefetch = prefetch;
        this.limit = prefetch - (prefetch >> 2);
    }

    @Override
    public void onSubscribe(Subscription s15) {
        if (SubscriptionHelper.setOnce(this, s15)) {
            if (s15 instanceof QueueSubscription) {
                QueueSubscription qs4 = (QueueSubscription)s15;
                int m15 = qs4.requestFusion(3);
                if (m15 == 1) {
                    this.fusionMode = m15;
                    this.queue = qs4;
                    this.done = true;
                    this.parent.innerComplete(this);
                    return;
                }
                if (m15 == 2) {
                    this.fusionMode = m15;
                    this.queue = qs4;
                    QueueDrainHelper.request(s15, this.prefetch);
                    return;
                }
            }
            this.queue = QueueDrainHelper.createQueue(this.prefetch);
            QueueDrainHelper.request(s15, this.prefetch);
        }
    }

    @Override
    public void onNext(T t15) {
        if (this.fusionMode == 0) {
            this.parent.innerNext(this, t15);
        } else {
            this.parent.drain();
        }
    }

    @Override
    public void onError(Throwable t15) {
        this.parent.innerError(this, t15);
    }

    @Override
    public void onComplete() {
        this.parent.innerComplete(this);
    }

    @Override
    public void request(long n15) {
        if (this.fusionMode != 1) {
            long p15 = this.produced + n15;
            if (p15 >= (long)this.limit) {
                this.produced = 0L;
                ((Subscription)this.get()).request(p15);
            } else {
                this.produced = p15;
            }
        }
    }

    @Override
    public void cancel() {
        SubscriptionHelper.cancel(this);
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone() {
        this.done = true;
    }

    public SimpleQueue<T> queue() {
        return this.queue;
    }
}

