/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscriptions;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.reactivestreams.Subscription;

public final class ArrayCompositeSubscription
extends AtomicReferenceArray<Subscription>
implements Disposable {
    private static final long serialVersionUID = 2746389416410565408L;

    public ArrayCompositeSubscription(int capacity) {
        super(capacity);
    }

    public boolean setResource(int index, Subscription resource) {
        Subscription o15;
        do {
            if ((o15 = (Subscription)this.get(index)) != SubscriptionHelper.CANCELLED) continue;
            if (resource != null) {
                resource.cancel();
            }
            return false;
        } while (!this.compareAndSet(index, o15, resource));
        if (o15 != null) {
            o15.cancel();
        }
        return true;
    }

    public Subscription replaceResource(int index, Subscription resource) {
        Subscription o15;
        do {
            if ((o15 = (Subscription)this.get(index)) != SubscriptionHelper.CANCELLED) continue;
            if (resource != null) {
                resource.cancel();
            }
            return null;
        } while (!this.compareAndSet(index, o15, resource));
        return o15;
    }

    @Override
    public void dispose() {
        if (this.get(0) != SubscriptionHelper.CANCELLED) {
            int s15 = this.length();
            for (int i15 = 0; i15 < s15; ++i15) {
                Subscription o15 = (Subscription)this.get(i15);
                if (o15 == SubscriptionHelper.CANCELLED || (o15 = (Subscription)this.getAndSet(i15, SubscriptionHelper.CANCELLED)) == SubscriptionHelper.CANCELLED || o15 == null) continue;
                o15.cancel();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.get(0) == SubscriptionHelper.CANCELLED;
    }
}

