/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.api.plugins.input.insns.InsnData;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.ArithOp;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import org.jetbrains.annotations.Nullable;

public class ArithNode
extends InsnNode {
    private final ArithOp op;

    public static ArithNode build(InsnData insn, ArithOp op4, ArgType type) {
        RegisterArg resArg = InsnArg.reg(insn, 0, ArithNode.fixResultType(op4, type));
        ArgType argType = ArithNode.fixArgType(op4, type);
        switch (insn.getRegsCount()) {
            case 2: {
                return new ArithNode(op4, resArg, InsnArg.reg(insn, 0, argType), InsnArg.reg(insn, 1, argType));
            }
            case 3: {
                return new ArithNode(op4, resArg, InsnArg.reg(insn, 1, argType), InsnArg.reg(insn, 2, argType));
            }
        }
        throw new JadxRuntimeException("Unexpected registers count in " + String.valueOf(insn));
    }

    public static ArithNode buildLit(InsnData insn, ArithOp op4, ArgType type) {
        RegisterArg resArg = InsnArg.reg(insn, 0, ArithNode.fixResultType(op4, type));
        ArgType argType = ArithNode.fixArgType(op4, type);
        LiteralArg litArg = InsnArg.lit(insn, argType);
        switch (insn.getRegsCount()) {
            case 1: {
                return new ArithNode(op4, resArg, InsnArg.reg(insn, 0, argType), litArg);
            }
            case 2: {
                return new ArithNode(op4, resArg, InsnArg.reg(insn, 1, argType), litArg);
            }
        }
        throw new JadxRuntimeException("Unexpected registers count in " + String.valueOf(insn));
    }

    private static ArgType fixResultType(ArithOp op4, ArgType type) {
        if (type == ArgType.INT && op4.isBitOp()) {
            return ArgType.INT_BOOLEAN;
        }
        return type;
    }

    private static ArgType fixArgType(ArithOp op4, ArgType type) {
        if (type == ArgType.INT && op4.isBitOp()) {
            return ArgType.NARROW_NUMBERS_NO_FLOAT;
        }
        return type;
    }

    public ArithNode(ArithOp op4, @Nullable RegisterArg res, InsnArg a15, InsnArg b15) {
        super(InsnType.ARITH, 2);
        this.op = op4;
        this.setResult(res);
        this.addArg(a15);
        this.addArg(b15);
    }

    public static ArithNode oneArgOp(ArithOp op4, InsnArg res, InsnArg a15) {
        ArithNode insn = new ArithNode(op4, null, res, a15);
        insn.add(AFlag.ARITH_ONEARG);
        return insn;
    }

    public ArithOp getOp() {
        return this.op;
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArithNode) || !super.isSame(obj)) {
            return false;
        }
        ArithNode other = (ArithNode)obj;
        return this.op == other.op && this.isSameLiteral(other);
    }

    private boolean isSameLiteral(ArithNode other) {
        long otherLit;
        InsnArg thisSecond = this.getArg(1);
        InsnArg otherSecond = other.getArg(1);
        if (thisSecond.isLiteral() != otherSecond.isLiteral()) {
            return false;
        }
        if (!thisSecond.isLiteral()) {
            return true;
        }
        long thisLit = ((LiteralArg)thisSecond).getLiteral();
        return thisLit == (otherLit = ((LiteralArg)otherSecond).getLiteral());
    }

    @Override
    public InsnNode copy() {
        ArithNode copy = new ArithNode(this.op, null, this.getArg(0).duplicate(), this.getArg(1).duplicate());
        return this.copyCommonParams(copy);
    }

    @Override
    public String toString() {
        StringBuilder sb5 = new StringBuilder();
        sb5.append(InsnUtils.formatOffset(this.offset));
        sb5.append(": ARITH ");
        if (this.contains(AFlag.ARITH_ONEARG)) {
            sb5.append(this.getArg(0)).append(' ').append(this.op.getSymbol()).append("= ").append(this.getArg(1));
        } else {
            RegisterArg result = this.getResult();
            if (result != null) {
                sb5.append(result).append(" = ");
            }
            sb5.append(this.getArg(0)).append(' ').append(this.op.getSymbol()).append(' ').append(this.getArg(1));
        }
        this.appendAttributes(sb5);
        return sb5.toString();
    }
}

