/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.deobf.NameMapper;
import jadx.core.utils.StringUtils;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BetterName {
    private static final Logger LOG = LoggerFactory.getLogger(BetterName.class);
    private static final boolean DEBUG = false;
    private static final double TOLERANCE = 0.001;

    public static String getBetterClassName(String firstName, String secondName) {
        return BetterName.getBetterName(firstName, secondName);
    }

    public static String getBetterResourceName(String firstName, String secondName) {
        return BetterName.getBetterName(firstName, secondName);
    }

    private static String getBetterName(String firstName, String secondName) {
        float firstRatio;
        float secondRatio;
        if (Objects.equals(firstName, secondName)) {
            return firstName;
        }
        if (StringUtils.isEmpty(firstName) || StringUtils.isEmpty(secondName)) {
            return StringUtils.notEmpty(firstName) ? firstName : secondName;
        }
        AnalyzeResult firstResult = BetterName.analyze(firstName);
        AnalyzeResult secondResult = BetterName.analyze(secondName);
        if ((firstResult.digitCount != 0 || secondResult.digitCount != 0) && (double)Math.abs((secondRatio = (float)secondResult.digitCount / (float)secondResult.length) - (firstRatio = (float)firstResult.digitCount / (float)firstResult.length)) >= 0.001) {
            return firstRatio <= secondRatio ? firstName : secondName;
        }
        return firstResult.length >= secondResult.length ? firstName : secondName;
    }

    private static AnalyzeResult analyze(String name) {
        AnalyzeResult result = new AnalyzeResult();
        StringUtils.visitCodePoints(name, cp4 -> {
            if (Character.isDigit(cp4)) {
                ++result.digitCount;
            }
            ++result.length;
        });
        return result;
    }

    @Deprecated
    public static String compareAndGet(String first, String second) {
        int secondRating;
        if (Objects.equals(first, second)) {
            return first;
        }
        int firstRating = BetterName.calcRating(first);
        boolean firstBetter = firstRating >= (secondRating = BetterName.calcRating(second));
        return firstBetter ? first : second;
    }

    @Deprecated
    public static int calcRating(String str) {
        int rating = str.length() * 3;
        rating += BetterName.differentCharsCount(str) * 20;
        if (NameMapper.isAllCharsPrintable(str)) {
            rating += 100;
        }
        if (NameMapper.isValidIdentifier(str)) {
            rating += 50;
        }
        if (str.contains("_")) {
            rating += 100;
        }
        return rating;
    }

    @Deprecated
    private static int differentCharsCount(String str) {
        String lower = str.toLowerCase(Locale.ROOT);
        HashSet chars = new HashSet();
        StringUtils.visitCodePoints(lower, chars::add);
        return chars.size();
    }

    private static class AnalyzeResult {
        private int length;
        private int digitCount;

        private AnalyzeResult() {
        }
    }
}

