/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.device.debugger;

import jadx.core.dex.instructions.args.ArgType;
import jadx.gui.device.debugger.ArtAdapter;
import jadx.gui.device.debugger.DebugSettings;
import jadx.gui.device.debugger.SmaliDebugger;
import jadx.gui.device.debugger.smali.SmaliRegister;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegisterObserver {
    private Map<Long, List<Info>> infoMap;
    private final List<SmaliRegisterMapping> regList = new ArrayList<SmaliRegisterMapping>();
    private final ArtAdapter.IArtAdapter art;
    private final String mthFullID;
    private boolean hasDbgInfo = false;

    private RegisterObserver(ArtAdapter.IArtAdapter art, String mthFullID) {
        this.infoMap = Collections.emptyMap();
        this.art = art;
        this.mthFullID = mthFullID;
    }

    @NotNull
    public static RegisterObserver merge(List<SmaliDebugger.RuntimeVarInfo> rtRegs, List<SmaliRegister> smaliRegs, ArtAdapter.IArtAdapter art, String mthFullID) {
        RegisterObserver adapter = new RegisterObserver(art, mthFullID);
        boolean bl4 = adapter.hasDbgInfo = !rtRegs.isEmpty();
        if (adapter.hasDbgInfo) {
            adapter.infoMap = new HashMap<Long, List<Info>>();
        }
        for (SmaliRegister sr4 : smaliRegs) {
            adapter.regList.add(new SmaliRegisterMapping(sr4));
        }
        adapter.regList.sort(Comparator.comparingInt(r15 -> r15.getSmaliRegister().getRuntimeRegNum()));
        for (SmaliDebugger.RuntimeVarInfo rt4 : rtRegs) {
            ArgType at4;
            SmaliRegisterMapping smaliRegMapping = adapter.getRegListEntry(rt4.getRegNum());
            SmaliRegister smaliReg = smaliRegMapping.getSmaliRegister();
            smaliRegMapping.addRuntimeVarInfo(rt4);
            String type = rt4.getSignature();
            if (type.isEmpty()) {
                type = rt4.getType();
            }
            if ((at4 = ArgType.parse(type)) != null) {
                type = at4.toString();
            }
            Info load = new Info(smaliReg.getRegNum(), true, rt4.getName(), type);
            Info unload = new Info(smaliReg.getRegNum(), false, null, null);
            adapter.infoMap.computeIfAbsent(Long.valueOf(rt4.getStartOffset()), k15 -> new ArrayList()).add(load);
            adapter.infoMap.computeIfAbsent(Long.valueOf(rt4.getEndOffset()), k15 -> new ArrayList()).add(unload);
        }
        return adapter;
    }

    @NotNull
    public List<SmaliRegister> getInitializedList(long codeOffset) {
        List<SmaliRegister> ret = Collections.emptyList();
        for (SmaliRegisterMapping smaliRegisterMapping : this.regList) {
            if (!smaliRegisterMapping.getSmaliRegister().isInitialized(codeOffset)) continue;
            if (ret.isEmpty()) {
                ret = new ArrayList<SmaliRegister>();
            }
            ret.add(smaliRegisterMapping.getSmaliRegister());
        }
        return ret;
    }

    @Nullable
    public SmaliDebugger.RuntimeVarInfo getInfo(int runtimeNum, long codeOffset) {
        SmaliRegisterMapping list2 = this.getRegListEntry(runtimeNum);
        for (SmaliDebugger.RuntimeVarInfo info : list2.getRuntimeVarInfoList()) {
            if ((long)info.getStartOffset() > codeOffset) break;
            if (!info.isInitialized(codeOffset)) continue;
            return info;
        }
        return null;
    }

    private SmaliRegisterMapping getRegListEntry(int regNum) {
        try {
            return this.regList.get(regNum);
        }
        catch (IndexOutOfBoundsException e15) {
            throw new RuntimeException(String.format("Register %d does not exist (size: %d).\n %s\n Method: %s", regNum, this.regList.size(), this.buildDeviceInfo(), this.mthFullID), e15);
        }
    }

    private String buildDeviceInfo() {
        DebugSettings debugSettings = DebugSettings.INSTANCE;
        return "Device: " + String.valueOf(debugSettings.getDevice().getDeviceInfo()) + ", Android: " + debugSettings.getVer() + ", ArtAdapter: " + this.art.getClass().getSimpleName();
    }

    @NotNull
    public List<Info> getInfoAt(long codeOffset) {
        List<Info> list2;
        if (this.hasDbgInfo && (list2 = this.infoMap.get(codeOffset)) != null) {
            return list2;
        }
        return Collections.emptyList();
    }

    public static class SmaliRegisterMapping {
        private final SmaliRegister smaliRegister;
        private List<SmaliDebugger.RuntimeVarInfo> rtList = Collections.emptyList();

        public SmaliRegisterMapping(SmaliRegister smaliRegister) {
            this.smaliRegister = smaliRegister;
        }

        public SmaliRegister getSmaliRegister() {
            return this.smaliRegister;
        }

        @NotNull
        public List<SmaliDebugger.RuntimeVarInfo> getRuntimeVarInfoList() {
            return this.rtList;
        }

        public void addRuntimeVarInfo(SmaliDebugger.RuntimeVarInfo rt4) {
            if (this.rtList.isEmpty()) {
                this.rtList = new ArrayList<SmaliDebugger.RuntimeVarInfo>();
            }
            this.rtList.add(rt4);
        }
    }

    public static class Info {
        private final int smaliRegNum;
        private final boolean load;
        private final String name;
        private final String type;

        private Info(int smaliRegNum, boolean load, String name, String type) {
            this.smaliRegNum = smaliRegNum;
            this.load = load;
            this.name = name;
            this.type = type;
        }

        public int getSmaliRegNum() {
            return this.smaliRegNum;
        }

        public boolean isLoad() {
            return this.load;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }
}

