/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.plugins.context;

import jadx.core.plugins.PluginContext;
import jadx.gui.plugins.context.CodePopupAction;
import jadx.gui.plugins.context.GuiPluginContext;
import jadx.gui.plugins.context.ITreeInputCategory;
import jadx.gui.plugins.context.TreePopupMenuEntry;
import jadx.gui.settings.data.ITabStatePersist;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.codearea.JNodePopupBuilder;
import jadx.gui.utils.ui.ActionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonGuiPluginsContext {
    private static final Logger LOG = LoggerFactory.getLogger(CommonGuiPluginsContext.class);
    private final MainWindow mainWindow;
    private final Map<PluginContext, GuiPluginContext> pluginsMap = new HashMap<PluginContext, GuiPluginContext>();
    private final List<CodePopupAction> codePopupActionList = new ArrayList<CodePopupAction>();
    private final List<TreePopupMenuEntry> treePopupMenuEntries = new ArrayList<TreePopupMenuEntry>();
    private final List<ITreeInputCategory> treeInputCategories = new ArrayList<ITreeInputCategory>();
    private final List<ITabStatePersist> tabStatePersistAdapters = new ArrayList<ITabStatePersist>();

    public CommonGuiPluginsContext(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    public GuiPluginContext buildForPlugin(PluginContext pluginContext) {
        GuiPluginContext guiPluginContext = new GuiPluginContext(this, pluginContext);
        this.pluginsMap.put(pluginContext, guiPluginContext);
        return guiPluginContext;
    }

    @Nullable
    public GuiPluginContext getPluginGuiContext(PluginContext pluginContext) {
        return this.pluginsMap.get(pluginContext);
    }

    @Nullable
    public GuiPluginContext getGuiPluginContextById(String pluginId) {
        for (GuiPluginContext guiPluginContext : this.pluginsMap.values()) {
            if (!guiPluginContext.getPluginContext().getPluginId().equals(pluginId)) continue;
            return guiPluginContext;
        }
        return null;
    }

    public void reset() {
        this.codePopupActionList.clear();
        this.treePopupMenuEntries.clear();
        this.treeInputCategories.clear();
        this.mainWindow.resetPluginsMenu();
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    public List<CodePopupAction> getCodePopupActionList() {
        return this.codePopupActionList;
    }

    public List<TreePopupMenuEntry> getTreePopupMenuEntries() {
        return this.treePopupMenuEntries;
    }

    public List<ITreeInputCategory> getTreeInputCategories() {
        return this.treeInputCategories;
    }

    public List<ITabStatePersist> getTabStatePersistAdapters() {
        return this.tabStatePersistAdapters;
    }

    public void addMenuAction(String name, Runnable action) {
        ActionHandler item = new ActionHandler(ev4 -> {
            try {
                this.mainWindow.getBackgroundExecutor().execute(name, action);
            }
            catch (Exception e15) {
                LOG.error("Error running action for menu item: {}", (Object)name, (Object)e15);
            }
        });
        item.setNameAndDesc(name);
        this.mainWindow.addToPluginsMenu(item);
    }

    public void appendPopupMenus(CodeArea codeArea, JNodePopupBuilder popup) {
        if (this.codePopupActionList.isEmpty()) {
            return;
        }
        popup.addSeparator();
        for (CodePopupAction codePopupAction : this.codePopupActionList) {
            popup.add(codePopupAction.buildAction(codeArea));
        }
    }
}

