/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea.theme;

import jadx.core.utils.StringUtils;
import jadx.gui.settings.JadxSettings;
import jadx.gui.ui.codearea.theme.DynamicCodeAreaTheme;
import jadx.gui.ui.codearea.theme.FallbackEditorTheme;
import jadx.gui.ui.codearea.theme.IEditorTheme;
import jadx.gui.ui.codearea.theme.RSTABundledTheme;
import jadx.gui.ui.codearea.theme.ThemeIdAndName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorThemeManager {
    private static final Logger LOG = LoggerFactory.getLogger(EditorThemeManager.class);
    private final List<IEditorTheme> themes = new ArrayList<IEditorTheme>();
    private final Map<String, IEditorTheme> themesMap = new HashMap<String, IEditorTheme>();
    private IEditorTheme currentTheme = new FallbackEditorTheme();

    public EditorThemeManager(JadxSettings settings) {
        this.registerThemes();
        if (StringUtils.isEmpty(settings.getEditorTheme())) {
            IEditorTheme defaultTheme = this.themes.get(0);
            settings.setEditorTheme(defaultTheme.getId());
        }
    }

    private void registerThemes() {
        this.registerTheme(new DynamicCodeAreaTheme());
        this.registerTheme(new RSTABundledTheme("default"));
        this.registerTheme(new RSTABundledTheme("eclipse"));
        this.registerTheme(new RSTABundledTheme("idea"));
        this.registerTheme(new RSTABundledTheme("vs"));
        this.registerTheme(new RSTABundledTheme("dark"));
        this.registerTheme(new RSTABundledTheme("monokai"));
        this.registerTheme(new RSTABundledTheme("druid"));
    }

    public void registerTheme(IEditorTheme editorTheme) {
        IEditorTheme prev = this.themesMap.put(editorTheme.getId(), editorTheme);
        if (prev != null) {
            this.themes.remove(prev);
        }
        this.themes.add(editorTheme);
    }

    public synchronized void setTheme(String id5) {
        if (this.currentTheme.getId().equals(id5)) {
            return;
        }
        IEditorTheme newTheme = this.themesMap.get(id5);
        if (newTheme == null) {
            LOG.warn("Failed to resolve editor theme: {}", (Object)id5);
            return;
        }
        this.unload();
        try {
            newTheme.load();
        }
        catch (Throwable t15) {
            LOG.warn("Failed to load editor theme: {}", (Object)id5, (Object)t15);
        }
        this.currentTheme = newTheme;
    }

    public void apply(RSyntaxTextArea textArea) {
        this.currentTheme.apply(textArea);
    }

    public ThemeIdAndName[] getThemeIdNameArray() {
        return (ThemeIdAndName[])this.themes.stream().map(EditorThemeManager::toThemeIdAndName).toArray(ThemeIdAndName[]::new);
    }

    public ThemeIdAndName getCurrentThemeIdName() {
        return EditorThemeManager.toThemeIdAndName(this.currentTheme);
    }

    private static ThemeIdAndName toThemeIdAndName(IEditorTheme t15) {
        return new ThemeIdAndName(t15.getId(), t15.getName());
    }

    public void unload() {
        try {
            this.currentTheme.unload();
        }
        catch (Throwable t15) {
            LOG.warn("Failed to unload editor theme: {}", (Object)this.currentTheme.getId(), (Object)t15);
        }
    }
}

