/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.dialog;

import jadx.api.JavaPackage;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.Icons;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ExcludePkgDialog
extends JDialog {
    private static final long serialVersionUID = -1111111202104151030L;
    private final transient MainWindow mainWindow;
    private transient JTree tree;
    private transient DefaultMutableTreeNode treeRoot;
    private final transient List<PkgNode> roots = new ArrayList<PkgNode>();

    public ExcludePkgDialog(MainWindow mainWindow) {
        super(mainWindow);
        this.mainWindow = mainWindow;
        this.initUI();
        UiUtils.addEscapeShortCutToDispose(this);
        this.initPackageList();
    }

    private void initUI() {
        this.setTitle(NLS.str("exclude_dialog.title"));
        this.tree = new JTree();
        this.tree.setRowHeight(-1);
        this.treeRoot = new DefaultMutableTreeNode("Packages");
        DefaultTreeModel treeModel = new DefaultTreeModel(this.treeRoot);
        this.tree.setModel(treeModel);
        this.tree.setCellRenderer(new PkgListCellRenderer());
        JScrollPane listPanel = new JScrollPane(this.tree);
        listPanel.setBorder(BorderFactory.createEmptyBorder());
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e15) {
                TreePath path = ExcludePkgDialog.this.tree.getPathForLocation(e15.getX(), e15.getY());
                if (path != null && path.getLastPathComponent() instanceof PkgNode) {
                    PkgNode node = (PkgNode)path.getLastPathComponent();
                    node.toggle();
                    ExcludePkgDialog.this.repaint();
                }
            }
        });
        JPanel actionPanel = new JPanel();
        actionPanel.setLayout(new BoxLayout(actionPanel, 2));
        JButton btnOk = new JButton(NLS.str("common_dialog.ok"));
        JButton btnAll = new JButton(NLS.str("exclude_dialog.select_all"));
        JButton btnInvert = new JButton(NLS.str("exclude_dialog.invert"));
        JButton btnDeselect = new JButton(NLS.str("exclude_dialog.deselect"));
        actionPanel.add(btnDeselect);
        actionPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        actionPanel.add(btnInvert);
        actionPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        actionPanel.add(btnAll);
        actionPanel.add(Box.createHorizontalGlue());
        actionPanel.add((Component)btnOk, "Last");
        JPanel mainPane = new JPanel(new BorderLayout(5, 5));
        mainPane.add((Component)listPanel, "Center");
        mainPane.add((Component)actionPanel, "South");
        mainPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(mainPane);
        this.pack();
        this.setSize(600, 700);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.MODELESS);
        btnOk.addActionListener(e15 -> {
            this.mainWindow.getWrapper().setExcludedPackages(this.getExcludes());
            this.mainWindow.reopen();
            this.dispose();
        });
        btnAll.addActionListener(e15 -> {
            this.roots.forEach(p15 -> p15.setSelected(true));
            this.tree.updateUI();
        });
        btnDeselect.addActionListener(e15 -> {
            this.roots.forEach(p15 -> p15.setSelected(false));
            this.tree.updateUI();
        });
        btnInvert.addActionListener(e15 -> {
            this.roots.forEach(PkgNode::toggle);
            this.tree.updateUI();
        });
    }

    private void initPackageList() {
        List<String> pkgs = this.mainWindow.getWrapper().getPackages().stream().map(JavaPackage::getFullName).collect(Collectors.toList());
        this.getPackageTree(pkgs).forEach(this.treeRoot::add);
        this.initCheckbox();
        this.tree.expandPath(new TreePath(this.treeRoot.getPath()));
    }

    private List<PkgNode> getPackageTree(List<String> names) {
        ArrayList<PkgNode> roots = new ArrayList<PkgNode>();
        HashSet<String> nameSet = new HashSet<String>();
        HashMap<String, List<PkgNode>> childMap = new HashMap<String, List<PkgNode>>();
        for (String name : names) {
            int pos;
            String parent = "";
            int last = 0;
            do {
                String fullName;
                if ((pos = name.indexOf(46, last)) == -1) {
                    pos = name.length();
                }
                if (!nameSet.contains(fullName = name.substring(0, pos))) {
                    nameSet.add(fullName);
                    PkgNode node = new PkgNode(fullName, name.substring(last, pos));
                    if (!parent.isEmpty()) {
                        childMap.computeIfAbsent(parent, k15 -> new ArrayList()).add(node);
                    } else {
                        roots.add(node);
                    }
                }
                parent = fullName;
            } while ((last = pos + 1) < name.length());
        }
        this.addToParent(null, roots, childMap);
        return this.roots;
    }

    private PkgNode addToParent(PkgNode parent, List<PkgNode> roots, Map<String, List<PkgNode>> childMap) {
        for (PkgNode root : roots) {
            List<PkgNode> children;
            String tempFullName = root.getFullName();
            while ((children = childMap.get(tempFullName)) != null) {
                if (children.size() == 1) {
                    PkgNode next = children.get(0);
                    next.name = root.name + "." + next.name;
                    tempFullName = next.fullName;
                    next.fullName = root.fullName;
                    root = next;
                    continue;
                }
                this.addToParent(root, children, childMap);
                break;
            }
            if (parent == null) {
                this.roots.add(root);
                continue;
            }
            parent.add(root);
        }
        return parent;
    }

    private List<String> getExcludes() {
        ArrayList<String> excludes = new ArrayList<String>();
        this.walkTree(true, p15 -> excludes.add(p15.getFullName()));
        return excludes;
    }

    private void initCheckbox() {
        Font tmp = this.mainWindow.getSettings().getCodeFont();
        Font font = tmp.deriveFont((float)tmp.getSize() + 1.0f);
        HashSet<String> excluded = new HashSet<String>(this.mainWindow.getWrapper().getExcludedPackages());
        this.walkTree(false, p15 -> p15.initCheckbox(excluded.contains(p15.getFullName()), font));
    }

    private void walkTree(boolean findSelected, Consumer<PkgNode> consumer) {
        ArrayList<PkgNode> queue = new ArrayList<PkgNode>(this.roots);
        for (int i15 = 0; i15 < queue.size(); ++i15) {
            PkgNode node = (PkgNode)queue.get(i15);
            if (findSelected && node.isSelected()) {
                consumer.accept(node);
                continue;
            }
            if (!findSelected) {
                consumer.accept(node);
            }
            for (int j15 = 0; j15 < node.getChildCount(); ++j15) {
                queue.add((PkgNode)node.getChildAt(j15));
            }
        }
    }

    private static class PkgListCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -1111111202104151235L;

        private PkgListCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof PkgNode) {
                PkgNode node = (PkgNode)value;
                node.checkbox.setBackground(tree.getBackground());
                node.checkbox.setForeground(tree.getForeground());
                return node.checkbox;
            }
            Component c15 = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            this.setIcon(Icons.PACKAGE);
            return c15;
        }
    }

    private static class PkgNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -1111111202104151430L;
        String name;
        String fullName;
        JCheckBox checkbox;

        PkgNode(String fullName, String name) {
            this.name = name;
            this.fullName = fullName;
        }

        void initCheckbox(boolean select, Font font) {
            if (!select && this.getParent() instanceof PkgNode) {
                select = ((PkgNode)this.getParent()).isSelected();
            }
            this.checkbox = new JCheckBox(this.name, select);
            this.checkbox.setFont(font);
        }

        boolean toggle() {
            boolean selected = !this.checkbox.isSelected();
            this.setSelected(selected);
            this.toggleParents(selected);
            return selected;
        }

        void toggleParents(boolean select) {
            if (this.getParent() instanceof PkgNode) {
                PkgNode p15 = (PkgNode)this.getParent();
                if (select) {
                    select = p15.isChildrenAllSelected();
                    if (select) {
                        p15.checkbox.setSelected(true);
                        p15.toggleParents(true);
                    }
                } else {
                    p15.checkbox.setSelected(false);
                    p15.toggleParents(false);
                }
            }
        }

        void setSelected(boolean select) {
            this.checkbox.setSelected(select);
            for (int i15 = 0; i15 < this.getChildCount(); ++i15) {
                ((PkgNode)this.getChildAt(i15)).setSelected(select);
            }
        }

        boolean isSelected() {
            return this.checkbox.isSelected();
        }

        String getFullName() {
            return this.fullName;
        }

        String getDisplayName() {
            return this.name;
        }

        boolean isChildrenAllSelected() {
            for (int i15 = 0; i15 < this.getChildCount(); ++i15) {
                if (((PkgNode)this.getChildAt(i15)).isSelected()) continue;
                return false;
            }
            return true;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

