/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.hexviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.exbin.bined.CodeAreaCaretListener;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.DataChangedListener;
import org.exbin.bined.SelectionChangedListener;
import org.exbin.bined.SelectionRange;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.swing.section.SectCodeArea;

public class HexEditorHeader
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final String HEX_ALPHABET = "0123456789ABCDEF";
    private final SectCodeArea parent;
    private final DataChangedListener dataChangedListener = this::repaint;
    private final CodeAreaCaretListener caretMovedListener = caretPosition -> this.repaint();
    private final SelectionChangedListener selectionChangedListener = this::repaint;
    private Dimension minimumSize = null;
    private Dimension preferredSize = null;

    public HexEditorHeader(SectCodeArea parent) {
        this.parent = parent;
        if (this.parent != null) {
            this.parent.addCaretMovedListener(this.caretMovedListener);
            this.parent.addSelectionChangedListener(this.selectionChangedListener);
            this.parent.addDataChangedListener(this.dataChangedListener);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.parent != null) {
            this.parent.addCaretMovedListener(this.caretMovedListener);
            this.parent.addSelectionChangedListener(this.selectionChangedListener);
            this.parent.addDataChangedListener(this.dataChangedListener);
        }
    }

    @Override
    public void removeNotify() {
        if (this.parent != null) {
            this.parent.removeCaretMovedListener(this.caretMovedListener);
            this.parent.removeSelectionChangedListener(this.selectionChangedListener);
            this.parent.removeDataChangedListener(this.dataChangedListener);
        }
        super.removeNotify();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.minimumSize != null) {
            return this.minimumSize;
        }
        Insets i15 = this.getInsets();
        FontMetrics fm4 = this.getFontMetrics(this.parent.getFont());
        if (fm4 == null) {
            return new Dimension(100, 20);
        }
        int ch4 = fm4.getHeight() + 2;
        int cw4 = fm4.stringWidth(HEX_ALPHABET) / 16;
        String sampleText = "Sel: 00000000:00000000 Len: 00000000/00000000 TXT UTF-8";
        int minTextWidth = fm4.stringWidth(sampleText);
        int minimumWidth = minTextWidth + cw4 * 5 + i15.left + i15.right;
        int minimumHeight = ch4 + 5 + i15.top + i15.bottom;
        return new Dimension(minimumWidth, minimumHeight);
    }

    @Override
    public void setMinimumSize(Dimension minimumSize) {
        this.minimumSize = minimumSize;
        this.revalidate();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        Insets i15 = this.getInsets();
        FontMetrics fm4 = this.getFontMetrics(this.parent.getFont());
        if (fm4 == null) {
            return this.getMinimumSize();
        }
        int ch4 = fm4.getHeight() + 2;
        int cw4 = fm4.stringWidth(HEX_ALPHABET) / 16;
        String sampleText = "Sel: 00000000:00000000 Len: 00000000/00000000 TXT UTF-8";
        int preferredTextWidth = fm4.stringWidth(sampleText);
        int preferredWidth = preferredTextWidth + cw4 * 10 + i15.left + i15.right;
        int preferredHeight = ch4 + 5 + i15.top + i15.bottom;
        return new Dimension(preferredWidth, preferredHeight);
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
        this.revalidate();
    }

    @Override
    protected void paintComponent(Graphics g15) {
        if (g15 instanceof Graphics2D) {
            Graphics2D g25 = (Graphics2D)g15;
            g25.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Insets i15 = this.getInsets();
        int fw4 = this.getWidth();
        int fh4 = this.getHeight();
        int w15 = fw4 - i15.left - i15.right;
        int h15 = fh4 - i15.top - i15.bottom;
        g15.setFont(this.parent.getFont());
        FontMetrics fm4 = g15.getFontMetrics();
        if (fm4 == null) {
            return;
        }
        int ca5 = fm4.getAscent() + 1;
        int ch4 = fm4.getHeight() + 2;
        int cw4 = fm4.stringWidth(HEX_ALPHABET) / 16;
        if (cw4 <= 0) {
            cw4 = 1;
        }
        Color separatorForeground = UIManager.getColor("Separator.foreground");
        Color themeBackground = UIManager.getColor("Panel.background");
        Color themeForeground = UIManager.getColor("Panel.foreground");
        SelectionRange selectionRange = this.parent.getSelection();
        long ss4 = selectionRange.getStart();
        long se5 = selectionRange.getEnd();
        long sl4 = selectionRange.getLength();
        long length = this.parent.getDataSize();
        int ty4 = i15.top + (h15 - ch4) / 2 + ca5;
        g15.setColor(themeBackground);
        g15.fillRect(i15.left, i15.top, w15, h15);
        g15.setColor(themeForeground);
        int currentX = i15.left + cw4 / 2;
        String selLabel = "Sel:";
        g15.drawString(selLabel, currentX, ty4);
        String sss = this.addressString(ss4);
        g15.drawString(sss, currentX += fm4.stringWidth(selLabel) + cw4, ty4);
        String separator1 = ":";
        g15.drawString(separator1, currentX += fm4.stringWidth(sss), ty4);
        String ses = this.addressString(se5);
        g15.drawString(ses, currentX += fm4.stringWidth(separator1), ty4);
        int dividerTopY = i15.top;
        int dividerHeight = h15;
        g15.setColor(separatorForeground);
        g15.fillRect(currentX += fm4.stringWidth(ses) + cw4, dividerTopY, 1, dividerHeight);
        g15.setColor(themeForeground);
        String lenLabel = "Len:";
        g15.drawString(lenLabel, currentX += cw4, ty4);
        String sls = this.addressString(sl4);
        g15.drawString(sls, currentX += fm4.stringWidth(lenLabel) + cw4, ty4);
        String separator2 = "/";
        g15.drawString(separator2, currentX += fm4.stringWidth(sls), ty4);
        String ls4 = this.addressString(length);
        g15.drawString(ls4, currentX += fm4.stringWidth(separator2), ty4);
        g15.setColor(separatorForeground);
        g15.fillRect(currentX += fm4.stringWidth(ls4) + cw4, dividerTopY, 1, dividerHeight);
        currentX += cw4;
        g15.setColor(themeForeground);
        String statusTxtHex = "HEX";
        CodeAreaSection section = this.parent.getActiveSection();
        if (section == BasicCodeAreaSection.TEXT_PREVIEW) {
            statusTxtHex = "TXT";
        }
        g15.drawString(statusTxtHex, currentX, ty4);
        g15.setColor(separatorForeground);
        g15.fillRect(currentX += fm4.stringWidth(statusTxtHex) + cw4, dividerTopY, 1, dividerHeight);
        g15.setColor(themeForeground);
        String statusCharset = this.parent.getCharset().name();
        g15.drawString(statusCharset, currentX += cw4, ty4);
        g15.setColor(separatorForeground);
        g15.fillRect(i15.left, i15.top + h15 - 1, w15, 1);
    }

    public String addressString(long address) {
        return String.format("%08X", address);
    }
}

