/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.code;

import jadx.plugins.input.java.data.attributes.stack.StackFrame;
import jadx.plugins.input.java.data.attributes.stack.StackValueType;
import java.util.Arrays;

public class StackState {
    private int pos = -1;
    private final StackValueType[] stack;

    public StackState(int maxStack) {
        this.stack = new StackValueType[maxStack];
    }

    private StackState(int pos, StackValueType[] stack) {
        this.pos = pos;
        this.stack = stack;
    }

    public StackState copy() {
        return new StackState(this.pos, Arrays.copyOf(this.stack, this.stack.length));
    }

    public StackState fillFromFrame(StackFrame frame) {
        int stackSize = frame.getStackSize();
        this.pos = stackSize - 1;
        if (stackSize > 0) {
            System.arraycopy(frame.getStackValueTypes(), 0, this.stack, 0, stackSize);
        }
        return this;
    }

    public int peek() {
        return this.pos;
    }

    public int peekAt(int at4) {
        return this.pos - at4;
    }

    public StackValueType peekTypeAt(int at4) {
        int p15 = this.pos - at4;
        if (this.checkStackIndex(p15)) {
            return this.stack[p15];
        }
        return StackValueType.NARROW;
    }

    public int insert(int at4, StackValueType type) {
        int p15 = this.pos - at4;
        System.arraycopy(this.stack, p15, this.stack, p15 + 1, at4);
        this.stack[p15] = type;
        ++this.pos;
        return p15;
    }

    public int push(StackValueType type) {
        int p15;
        if (this.checkStackIndex(p15 = ++this.pos)) {
            this.stack[p15] = type;
        }
        return p15;
    }

    private boolean checkStackIndex(int p15) {
        return p15 >= 0 && p15 < this.stack.length;
    }

    public int pop() {
        return this.pos--;
    }

    public void clear() {
        this.pos = -1;
    }

    public String toString() {
        int size = this.pos + 1;
        Object arr = size == 0 ? "empty" : (size > 0 && size < this.stack.length ? Arrays.toString((Object[])Arrays.copyOf(this.stack, size)) : Arrays.toString((Object[])this.stack) + " (max)");
        return "Stack: " + size + ": " + (String)arr;
    }
}

