/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenRewriteStream
extends CommonTokenStream {
    public static final String DEFAULT_PROGRAM_NAME = "default";
    public static final int PROGRAM_INIT_SIZE = 100;
    public static final int MIN_TOKEN_INDEX = 0;
    protected Map<String, List<RewriteOperation>> programs = null;
    protected Map<String, Integer> lastRewriteTokenIndexes = null;

    public TokenRewriteStream() {
        this.init();
    }

    protected void init() {
        this.programs = new HashMap<String, List<RewriteOperation>>();
        this.programs.put(DEFAULT_PROGRAM_NAME, new ArrayList(100));
        this.lastRewriteTokenIndexes = new HashMap<String, Integer>();
    }

    public TokenRewriteStream(TokenSource tokenSource) {
        super(tokenSource);
        this.init();
    }

    public TokenRewriteStream(TokenSource tokenSource, int channel) {
        super(tokenSource, channel);
        this.init();
    }

    public void rollback(int instructionIndex) {
        this.rollback(DEFAULT_PROGRAM_NAME, instructionIndex);
    }

    public void rollback(String programName, int instructionIndex) {
        List<RewriteOperation> is4 = this.programs.get(programName);
        if (is4 != null) {
            this.programs.put(programName, is4.subList(0, instructionIndex));
        }
    }

    public void deleteProgram() {
        this.deleteProgram(DEFAULT_PROGRAM_NAME);
    }

    public void deleteProgram(String programName) {
        this.rollback(programName, 0);
    }

    public void insertAfter(Token t15, Object text) {
        this.insertAfter(DEFAULT_PROGRAM_NAME, t15, text);
    }

    public void insertAfter(int index, Object text) {
        this.insertAfter(DEFAULT_PROGRAM_NAME, index, text);
    }

    public void insertAfter(String programName, Token t15, Object text) {
        this.insertAfter(programName, t15.getTokenIndex(), text);
    }

    public void insertAfter(String programName, int index, Object text) {
        this.insertBefore(programName, index + 1, text);
    }

    public void insertBefore(Token t15, Object text) {
        this.insertBefore(DEFAULT_PROGRAM_NAME, t15, text);
    }

    public void insertBefore(int index, Object text) {
        this.insertBefore(DEFAULT_PROGRAM_NAME, index, text);
    }

    public void insertBefore(String programName, Token t15, Object text) {
        this.insertBefore(programName, t15.getTokenIndex(), text);
    }

    public void insertBefore(String programName, int index, Object text) {
        InsertBeforeOp op4 = new InsertBeforeOp(index, text);
        List<RewriteOperation> rewrites = this.getProgram(programName);
        op4.instructionIndex = rewrites.size();
        rewrites.add(op4);
    }

    public void replace(int index, Object text) {
        this.replace(DEFAULT_PROGRAM_NAME, index, index, text);
    }

    public void replace(int from, int to4, Object text) {
        this.replace(DEFAULT_PROGRAM_NAME, from, to4, text);
    }

    public void replace(Token indexT, Object text) {
        this.replace(DEFAULT_PROGRAM_NAME, indexT, indexT, text);
    }

    public void replace(Token from, Token to4, Object text) {
        this.replace(DEFAULT_PROGRAM_NAME, from, to4, text);
    }

    public void replace(String programName, int from, int to4, Object text) {
        if (from > to4 || from < 0 || to4 < 0 || to4 >= this.tokens.size()) {
            throw new IllegalArgumentException("replace: range invalid: " + from + ".." + to4 + "(size=" + this.tokens.size() + ")");
        }
        ReplaceOp op4 = new ReplaceOp(from, to4, text);
        List<RewriteOperation> rewrites = this.getProgram(programName);
        op4.instructionIndex = rewrites.size();
        rewrites.add(op4);
    }

    public void replace(String programName, Token from, Token to4, Object text) {
        this.replace(programName, from.getTokenIndex(), to4.getTokenIndex(), text);
    }

    public void delete(int index) {
        this.delete(DEFAULT_PROGRAM_NAME, index, index);
    }

    public void delete(int from, int to4) {
        this.delete(DEFAULT_PROGRAM_NAME, from, to4);
    }

    public void delete(Token indexT) {
        this.delete(DEFAULT_PROGRAM_NAME, indexT, indexT);
    }

    public void delete(Token from, Token to4) {
        this.delete(DEFAULT_PROGRAM_NAME, from, to4);
    }

    public void delete(String programName, int from, int to4) {
        this.replace(programName, from, to4, null);
    }

    public void delete(String programName, Token from, Token to4) {
        this.replace(programName, from, to4, null);
    }

    public int getLastRewriteTokenIndex() {
        return this.getLastRewriteTokenIndex(DEFAULT_PROGRAM_NAME);
    }

    protected int getLastRewriteTokenIndex(String programName) {
        Integer I11 = this.lastRewriteTokenIndexes.get(programName);
        if (I11 == null) {
            return -1;
        }
        return I11;
    }

    protected void setLastRewriteTokenIndex(String programName, int i15) {
        this.lastRewriteTokenIndexes.put(programName, i15);
    }

    protected List<RewriteOperation> getProgram(String name) {
        List<RewriteOperation> is4 = this.programs.get(name);
        if (is4 == null) {
            is4 = this.initializeProgram(name);
        }
        return is4;
    }

    private List<RewriteOperation> initializeProgram(String name) {
        ArrayList<RewriteOperation> is4 = new ArrayList<RewriteOperation>(100);
        this.programs.put(name, is4);
        return is4;
    }

    public String toOriginalString() {
        this.fill();
        return this.toOriginalString(0, this.size() - 1);
    }

    public String toOriginalString(int start, int end) {
        StringBuilder buf = new StringBuilder();
        for (int i15 = start; i15 >= 0 && i15 <= end && i15 < this.tokens.size(); ++i15) {
            if (this.get(i15).getType() == -1) continue;
            buf.append(this.get(i15).getText());
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        this.fill();
        return this.toString(0, this.size() - 1);
    }

    public String toString(String programName) {
        this.fill();
        return this.toString(programName, 0, this.size() - 1);
    }

    @Override
    public String toString(int start, int end) {
        return this.toString(DEFAULT_PROGRAM_NAME, start, end);
    }

    public String toString(String programName, int start, int end) {
        List<RewriteOperation> rewrites = this.programs.get(programName);
        if (end > this.tokens.size() - 1) {
            end = this.tokens.size() - 1;
        }
        if (start < 0) {
            start = 0;
        }
        if (rewrites == null || rewrites.isEmpty()) {
            return this.toOriginalString(start, end);
        }
        StringBuffer buf = new StringBuffer();
        Map<Integer, ? extends RewriteOperation> indexToOp = this.reduceToSingleOperationPerIndex(rewrites);
        int i15 = start;
        while (i15 <= end && i15 < this.tokens.size()) {
            RewriteOperation op4 = indexToOp.get(i15);
            indexToOp.remove(i15);
            Token token = (Token)this.tokens.get(i15);
            if (op4 == null) {
                if (token.getType() != -1) {
                    buf.append(token.getText());
                }
                ++i15;
                continue;
            }
            i15 = op4.execute(buf);
        }
        if (end == this.tokens.size() - 1) {
            for (RewriteOperation rewriteOperation : indexToOp.values()) {
                if (rewriteOperation.index < this.tokens.size() - 1) continue;
                buf.append(rewriteOperation.text);
            }
        }
        return buf.toString();
    }

    protected Map<Integer, ? extends RewriteOperation> reduceToSingleOperationPerIndex(List<? extends RewriteOperation> rewrites) {
        int j15;
        List<ReplaceOp> prevReplaces;
        RewriteOperation op4;
        int i15;
        for (i15 = 0; i15 < rewrites.size(); ++i15) {
            op4 = rewrites.get(i15);
            if (op4 == null || !(op4 instanceof ReplaceOp)) continue;
            ReplaceOp rop = (ReplaceOp)rewrites.get(i15);
            List<InsertBeforeOp> inserts = this.getKindOfOps(rewrites, InsertBeforeOp.class, i15);
            for (int j16 = 0; j16 < inserts.size(); ++j16) {
                InsertBeforeOp iop = inserts.get(j16);
                if (iop.index == rop.index) {
                    rewrites.set(iop.instructionIndex, null);
                    rop.text = iop.text.toString() + (rop.text != null ? rop.text.toString() : "");
                    continue;
                }
                if (iop.index <= rop.index || iop.index > rop.lastIndex) continue;
                rewrites.set(iop.instructionIndex, null);
            }
            prevReplaces = this.getKindOfOps(rewrites, ReplaceOp.class, i15);
            for (j15 = 0; j15 < prevReplaces.size(); ++j15) {
                boolean same;
                ReplaceOp prevRop = prevReplaces.get(j15);
                if (prevRop.index >= rop.index && prevRop.lastIndex <= rop.lastIndex) {
                    rewrites.set(prevRop.instructionIndex, null);
                    continue;
                }
                boolean disjoint = prevRop.lastIndex < rop.index || prevRop.index > rop.lastIndex;
                boolean bl4 = same = prevRop.index == rop.index && prevRop.lastIndex == rop.lastIndex;
                if (prevRop.text == null && rop.text == null && !disjoint) {
                    rewrites.set(prevRop.instructionIndex, null);
                    rop.index = Math.min(prevRop.index, rop.index);
                    rop.lastIndex = Math.max(prevRop.lastIndex, rop.lastIndex);
                    System.out.println("new rop " + rop);
                    continue;
                }
                if (disjoint || same) continue;
                throw new IllegalArgumentException("replace op boundaries of " + rop + " overlap with previous " + prevRop);
            }
        }
        for (i15 = 0; i15 < rewrites.size(); ++i15) {
            op4 = rewrites.get(i15);
            if (op4 == null || !(op4 instanceof InsertBeforeOp)) continue;
            InsertBeforeOp iop = (InsertBeforeOp)rewrites.get(i15);
            List<InsertBeforeOp> prevInserts = this.getKindOfOps(rewrites, InsertBeforeOp.class, i15);
            for (int j17 = 0; j17 < prevInserts.size(); ++j17) {
                InsertBeforeOp prevIop = prevInserts.get(j17);
                if (prevIop.index != iop.index) continue;
                iop.text = this.catOpText(iop.text, prevIop.text);
                rewrites.set(prevIop.instructionIndex, null);
            }
            prevReplaces = this.getKindOfOps(rewrites, ReplaceOp.class, i15);
            for (j15 = 0; j15 < prevReplaces.size(); ++j15) {
                ReplaceOp rop = prevReplaces.get(j15);
                if (iop.index == rop.index) {
                    rop.text = this.catOpText(iop.text, rop.text);
                    rewrites.set(i15, null);
                    continue;
                }
                if (iop.index < rop.index || iop.index > rop.lastIndex) continue;
                throw new IllegalArgumentException("insert op " + iop + " within boundaries of previous " + rop);
            }
        }
        HashMap<Integer, RewriteOperation> m15 = new HashMap<Integer, RewriteOperation>();
        for (int i16 = 0; i16 < rewrites.size(); ++i16) {
            RewriteOperation op5 = rewrites.get(i16);
            if (op5 == null) continue;
            if (m15.get(op5.index) != null) {
                throw new Error("should only be one op per index");
            }
            m15.put(op5.index, op5);
        }
        return m15;
    }

    protected String catOpText(Object a15, Object b15) {
        String x15 = "";
        String y15 = "";
        if (a15 != null) {
            x15 = a15.toString();
        }
        if (b15 != null) {
            y15 = b15.toString();
        }
        return x15 + y15;
    }

    protected <T extends RewriteOperation> List<? extends T> getKindOfOps(List<? extends RewriteOperation> rewrites, Class<T> kind2) {
        return this.getKindOfOps(rewrites, kind2, rewrites.size());
    }

    protected <T extends RewriteOperation> List<? extends T> getKindOfOps(List<? extends RewriteOperation> rewrites, Class<T> kind2, int before) {
        ArrayList<T> ops = new ArrayList<T>();
        for (int i15 = 0; i15 < before && i15 < rewrites.size(); ++i15) {
            RewriteOperation op4 = rewrites.get(i15);
            if (op4 == null || !kind2.isInstance(op4)) continue;
            ops.add(kind2.cast(op4));
        }
        return ops;
    }

    public String toDebugString() {
        return this.toDebugString(0, this.size() - 1);
    }

    public String toDebugString(int start, int end) {
        StringBuilder buf = new StringBuilder();
        for (int i15 = start; i15 >= 0 && i15 <= end && i15 < this.tokens.size(); ++i15) {
            buf.append(this.get(i15));
        }
        return buf.toString();
    }

    class ReplaceOp
    extends RewriteOperation {
        protected int lastIndex;

        public ReplaceOp(int from, int to4, Object text) {
            super(from, text);
            this.lastIndex = to4;
        }

        public int execute(StringBuffer buf) {
            if (this.text != null) {
                buf.append(this.text);
            }
            return this.lastIndex + 1;
        }

        public String toString() {
            if (this.text == null) {
                return "<DeleteOp@" + TokenRewriteStream.this.tokens.get(this.index) + ".." + TokenRewriteStream.this.tokens.get(this.lastIndex) + ">";
            }
            return "<ReplaceOp@" + TokenRewriteStream.this.tokens.get(this.index) + ".." + TokenRewriteStream.this.tokens.get(this.lastIndex) + ":\"" + this.text + "\">";
        }
    }

    class InsertBeforeOp
    extends RewriteOperation {
        public InsertBeforeOp(int index, Object text) {
            super(index, text);
        }

        public int execute(StringBuffer buf) {
            buf.append(this.text);
            if (((Token)TokenRewriteStream.this.tokens.get(this.index)).getType() != -1) {
                buf.append(((Token)TokenRewriteStream.this.tokens.get(this.index)).getText());
            }
            return this.index + 1;
        }
    }

    public class RewriteOperation {
        protected int instructionIndex;
        protected int index;
        protected Object text;

        protected RewriteOperation(int index) {
            this.index = index;
        }

        protected RewriteOperation(int index, Object text) {
            this.index = index;
            this.text = text;
        }

        public int execute(StringBuffer buf) {
            return this.index;
        }

        public String toString() {
            String opName = this.getClass().getName();
            int $index = opName.indexOf(36);
            opName = opName.substring($index + 1, opName.length());
            return "<" + opName + "@" + TokenRewriteStream.this.tokens.get(this.index) + ":\"" + this.text + "\">";
        }
    }
}

