/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.binary_data;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.FinishableStream;
import org.exbin.auxiliary.binary_data.SeekableStream;

@ParametersAreNonnullByDefault
public class BinaryDataInputStream
extends InputStream
implements SeekableStream,
FinishableStream {
    @Nonnull
    private final BinaryData data;
    private long position = 0L;
    private long mark = 0L;

    public BinaryDataInputStream(BinaryData data) {
        this.data = data;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.data.getByte(this.position++) & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException ex4) {
            return -1;
        }
    }

    @Override
    public int read(byte[] output, int off, int len) throws IOException {
        if (output.length == 0 || len == 0) {
            return 0;
        }
        long dataSize = this.data.getDataSize();
        if (this.position > dataSize - (long)len) {
            if (this.position >= dataSize) {
                return -1;
            }
            len = (int)(dataSize - this.position);
        }
        this.data.copyToArray(this.position, output, off, len);
        this.position += (long)len;
        return len;
    }

    @Override
    public void close() throws IOException {
        this.finish();
    }

    @Override
    public int available() throws IOException {
        return (int)(this.data.getDataSize() - this.position);
    }

    @Override
    public void seek(long position) throws IOException {
        this.position = position;
    }

    @Override
    public long finish() throws IOException {
        this.position = this.data.getDataSize();
        return this.position;
    }

    @Override
    public long getProcessedSize() {
        return this.position;
    }

    @Override
    public long getStreamSize() {
        return this.data.getDataSize();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.position = this.mark;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.position;
    }

    @Override
    public long skip(long n15) throws IOException {
        long dataSize = this.data.getDataSize();
        if (this.position + n15 < dataSize) {
            this.position += n15;
            return n15;
        }
        long skipped = dataSize - this.position;
        this.position = dataSize;
        return skipped;
    }
}

