/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.basic;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CodingErrorAction;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.swing.CodeAreaCharAssessor;
import org.exbin.bined.swing.CodeAreaPaintState;

@ParametersAreNonnullByDefault
public class DefaultCodeAreaCharAssessor
implements CodeAreaCharAssessor {
    protected final CodeAreaCharAssessor parentAssessor;
    protected char[] charMapping = null;
    protected long dataSize;
    protected int maxBytesPerChar;
    protected byte[] rowData;
    protected Charset charset;
    private CharsetDecoder decoder;
    private ByteBuffer byteBuffer;
    private CharBuffer charBuffer = null;

    public DefaultCodeAreaCharAssessor() {
        this.parentAssessor = null;
    }

    public DefaultCodeAreaCharAssessor(@Nullable CodeAreaCharAssessor parentAssessor) {
        this.parentAssessor = parentAssessor;
    }

    @Override
    public void startPaint(CodeAreaPaintState codeAreaPainterState) {
        this.dataSize = codeAreaPainterState.getDataSize();
        Charset painterCharset = codeAreaPainterState.getCharset();
        this.maxBytesPerChar = codeAreaPainterState.getMaxBytesPerChar();
        if (this.charBuffer == null) {
            this.charBuffer = CharBuffer.allocate(8);
        }
        if (this.charset != painterCharset) {
            this.charMapping = null;
            this.decoder = painterCharset.newDecoder();
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.byteBuffer = ByteBuffer.allocate(this.maxBytesPerChar);
            this.charset = painterCharset;
        }
        this.rowData = codeAreaPainterState.getRowData();
    }

    @Override
    public char getPreviewCharacter(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section) {
        if (byteOnRow > this.rowData.length - this.maxBytesPerChar) {
            return ' ';
        }
        if (this.maxBytesPerChar > 1) {
            this.decoder.reset();
            if (rowDataPosition + (long)this.maxBytesPerChar > this.dataSize) {
                this.byteBuffer.clear();
                this.byteBuffer.put(this.rowData, byteOnRow, (int)(this.dataSize - rowDataPosition));
            } else {
                this.byteBuffer.rewind();
                this.byteBuffer.put(this.rowData, byteOnRow, this.maxBytesPerChar);
            }
            this.byteBuffer.rewind();
            this.charBuffer.clear();
            try {
                this.decoder.decode(this.byteBuffer, this.charBuffer, true);
                if (this.charBuffer.position() > 0) {
                    this.charBuffer.rewind();
                    return this.charBuffer.get();
                }
            }
            catch (BufferUnderflowException | CoderMalfunctionError throwable) {}
        } else {
            if (this.charMapping == null) {
                this.buildCharMapping();
            }
            return this.charMapping[this.rowData[byteOnRow] & 0xFF];
        }
        return ' ';
    }

    @Override
    public char getPreviewCursorCharacter(long rowDataPosition, int byteOnRow, int charOnRow, byte[] cursorData, int cursorDataLength, CodeAreaSection section) {
        if (cursorDataLength == 0) {
            return ' ';
        }
        if (this.maxBytesPerChar > 1) {
            this.decoder.reset();
            this.byteBuffer.rewind();
            this.byteBuffer.put(cursorData, 0, cursorDataLength);
            this.byteBuffer.rewind();
            this.charBuffer.clear();
            try {
                this.decoder.decode(this.byteBuffer, this.charBuffer, true);
                if (this.charBuffer.position() > 0) {
                    this.charBuffer.rewind();
                    return this.charBuffer.get();
                }
            }
            catch (BufferUnderflowException | CoderMalfunctionError throwable) {}
        } else {
            if (this.charMapping == null) {
                this.buildCharMapping();
            }
            return this.charMapping[cursorData[0] & 0xFF];
        }
        return ' ';
    }

    @Override
    @Nonnull
    public Optional<CodeAreaCharAssessor> getParentCharAssessor() {
        return Optional.ofNullable(this.parentAssessor);
    }

    private void buildCharMapping() {
        this.charMapping = new char[256];
        ByteBuffer buffer = ByteBuffer.allocate(1);
        for (int i15 = 0; i15 < 256; ++i15) {
            buffer.rewind();
            buffer.put((byte)i15);
            this.decoder.reset();
            buffer.rewind();
            this.charBuffer.clear();
            try {
                this.decoder.decode(buffer, this.charBuffer, true);
                if (this.charBuffer.position() > 0) {
                    this.charBuffer.rewind();
                    this.charMapping[i15] = this.charBuffer.get();
                    continue;
                }
                this.charMapping[i15] = 32;
                continue;
            }
            catch (BufferUnderflowException | CoderMalfunctionError ex4) {
                this.charMapping[i15] = 32;
            }
        }
    }
}

