/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.basic;

import java.awt.Color;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.color.CodeAreaBasicColors;
import org.exbin.bined.swing.CodeAreaColorAssessor;
import org.exbin.bined.swing.CodeAreaPaintState;
import org.exbin.bined.swing.basic.color.CodeAreaColorsProfile;

@ParametersAreNonnullByDefault
public class DefaultCodeAreaColorAssessor
implements CodeAreaColorAssessor {
    protected final CodeAreaColorAssessor parentColorAssessor;
    protected CodeAreaSection activeSection = null;
    protected int codeLastCharPos;
    protected Color selectionColor;
    protected Color selectionMirrorColor;
    protected Color selectionBackground;
    protected Color selectionMirrorBackground;

    public DefaultCodeAreaColorAssessor() {
        this.parentColorAssessor = null;
    }

    public DefaultCodeAreaColorAssessor(@Nullable CodeAreaColorAssessor parentColorAssessor) {
        this.parentColorAssessor = parentColorAssessor;
    }

    @Override
    public void startPaint(CodeAreaPaintState codeAreaPainterState) {
        this.activeSection = codeAreaPainterState.getActiveSection();
        this.codeLastCharPos = codeAreaPainterState.getCodeLastCharPos();
        CodeAreaColorsProfile colorsProfile = codeAreaPainterState.getColorsProfile();
        this.selectionColor = colorsProfile.getColor(CodeAreaBasicColors.SELECTION_COLOR);
        this.selectionMirrorColor = colorsProfile.getColor(CodeAreaBasicColors.SELECTION_MIRROR_COLOR);
        this.selectionBackground = colorsProfile.getColor(CodeAreaBasicColors.SELECTION_BACKGROUND);
        this.selectionMirrorBackground = colorsProfile.getColor(CodeAreaBasicColors.SELECTION_MIRROR_BACKGROUND);
        if (this.parentColorAssessor != null) {
            this.parentColorAssessor.startPaint(codeAreaPainterState);
        }
    }

    @Override
    @Nullable
    public Color getPositionTextColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean inSelection) {
        if (inSelection) {
            return section == this.activeSection ? this.selectionColor : this.selectionMirrorColor;
        }
        if (this.parentColorAssessor != null) {
            return this.parentColorAssessor.getPositionTextColor(rowDataPosition, byteOnRow, charOnRow, section, inSelection);
        }
        return null;
    }

    @Override
    @Nullable
    public Color getPositionBackgroundColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean inSelection) {
        if (inSelection && section == BasicCodeAreaSection.CODE_MATRIX && charOnRow == this.codeLastCharPos) {
            inSelection = false;
        }
        if (inSelection) {
            return section == this.activeSection ? this.selectionBackground : this.selectionMirrorBackground;
        }
        if (this.parentColorAssessor != null) {
            return this.parentColorAssessor.getPositionBackgroundColor(rowDataPosition, byteOnRow, charOnRow, section, inSelection);
        }
        return null;
    }

    @Override
    @Nonnull
    public Optional<CodeAreaColorAssessor> getParentColorAssessor() {
        return Optional.ofNullable(this.parentColorAssessor);
    }
}

