/*
 * Decompiled with CFR 0.152.
 */
package org.fife.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.charset.Charset;

public class UnicodeReader
extends Reader {
    private InputStreamReader internalIn;
    private String encoding;
    private static final int BOM_SIZE = 4;

    public UnicodeReader(String file2) throws IOException {
        this(new File(file2));
    }

    public UnicodeReader(File file2) throws IOException {
        this(new FileInputStream(file2));
    }

    public UnicodeReader(File file2, String defaultEncoding) throws IOException {
        this((InputStream)new FileInputStream(file2), defaultEncoding);
    }

    public UnicodeReader(File file2, Charset defaultCharset) throws IOException {
        this((InputStream)new FileInputStream(file2), defaultCharset != null ? defaultCharset.name() : null);
    }

    public UnicodeReader(InputStream in4) throws IOException {
        this(in4, (String)null);
    }

    public UnicodeReader(InputStream in4, String defaultEncoding) throws IOException {
        this.init(in4, defaultEncoding);
    }

    public UnicodeReader(InputStream in4, Charset defaultCharset) throws IOException {
        this.init(in4, defaultCharset.name());
    }

    @Override
    public void close() throws IOException {
        this.internalIn.close();
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected void init(InputStream in4, String defaultEncoding) throws IOException {
        int unread;
        PushbackInputStream tempIn = new PushbackInputStream(in4, 4);
        byte[] bom = new byte[4];
        int n15 = tempIn.read(bom, 0, bom.length);
        if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            this.encoding = "UTF-32BE";
            unread = n15 - 4;
        } else if (n15 == 4 && bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            this.encoding = "UTF-32LE";
            unread = n15 - 4;
        } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            this.encoding = "UTF-8";
            unread = n15 - 3;
        } else if (bom[0] == -2 && bom[1] == -1) {
            this.encoding = "UTF-16BE";
            unread = n15 - 2;
        } else if (bom[0] == -1 && bom[1] == -2) {
            this.encoding = "UTF-16LE";
            unread = n15 - 2;
        } else {
            this.encoding = defaultEncoding;
            unread = n15;
        }
        if (unread > 0) {
            tempIn.unread(bom, n15 - unread, unread);
        } else if (unread < -1) {
            tempIn.unread(bom, 0, 0);
        }
        if (this.encoding == null) {
            this.internalIn = new InputStreamReader(tempIn);
            this.encoding = this.internalIn.getEncoding();
        } else {
            this.internalIn = new InputStreamReader((InputStream)tempIn, this.encoding);
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.internalIn.read(cbuf, off, len);
    }
}

