/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.net.URI;
import java.security.AccessControlException;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.UIManager;

public final class Util {
    public static final String PROPERTY_DONT_USE_SUBSTANCE_RENDERERS = "org.fife.ui.autocomplete.DontUseSubstanceRenderers";
    public static final String PROPERTY_ALLOW_DECORATED_AUTOCOMPLETE_WINDOWS = "org.fife.ui.autocomplete.allowDecoratedAutoCompleteWindows";
    public static final Color LIGHT_HYPERLINK_FG;
    private static final Pattern TAG_PATTERN;
    private static final boolean USE_SUBSTANCE_RENDERERS;
    private static boolean desktopCreationAttempted;
    private static Desktop desktop;
    private static final Object LOCK_DESKTOP_CREATION;

    private Util() {
    }

    public static boolean browse(URI uri) {
        Desktop desktop;
        boolean success = false;
        if (uri != null && (desktop = Util.getDesktop()) != null) {
            try {
                desktop.browse(uri);
                success = true;
            }
            catch (RuntimeException re5) {
                throw re5;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Desktop getDesktop() {
        Object object = LOCK_DESKTOP_CREATION;
        synchronized (object) {
            if (!desktopCreationAttempted) {
                desktopCreationAttempted = true;
                if (Desktop.isDesktopSupported()) {
                    desktop = Desktop.getDesktop();
                }
            }
        }
        return desktop;
    }

    static Color getHyperlinkForeground() {
        Color fg5 = UIManager.getColor("Label.foreground");
        if (fg5 == null) {
            fg5 = new JLabel().getForeground();
        }
        return Util.isLightForeground(fg5) ? LIGHT_HYPERLINK_FG : Color.blue;
    }

    public static Rectangle getScreenBoundsForPoint(int x15, int y15) {
        GraphicsDevice[] devices;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice device : devices = env.getScreenDevices()) {
            GraphicsConfiguration config = device.getDefaultConfiguration();
            Rectangle gcBounds = config.getBounds();
            if (!gcBounds.contains(x15, y15)) continue;
            return gcBounds;
        }
        return env.getMaximumWindowBounds();
    }

    public static boolean getShouldAllowDecoratingMainAutoCompleteWindows() {
        try {
            return Boolean.getBoolean(PROPERTY_ALLOW_DECORATED_AUTOCOMPLETE_WINDOWS);
        }
        catch (AccessControlException ace) {
            return false;
        }
    }

    public static boolean getUseSubstanceRenderers() {
        return USE_SUBSTANCE_RENDERERS;
    }

    public static boolean isLightForeground(Color fg5) {
        return fg5.getRed() > 160 && fg5.getGreen() > 160 && fg5.getBlue() > 160;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        int prefixLength = prefix.length();
        if (str.length() >= prefixLength) {
            return str.regionMatches(true, 0, prefix, 0, prefixLength);
        }
        return false;
    }

    public static String stripHtml(String text) {
        if (text == null || !text.startsWith("<html>")) {
            return text;
        }
        return TAG_PATTERN.matcher(text).replaceAll("");
    }

    static {
        boolean use;
        LIGHT_HYPERLINK_FG = new Color(0xD8FFFF);
        TAG_PATTERN = Pattern.compile("<[^>]*>");
        LOCK_DESKTOP_CREATION = new Object();
        try {
            use = !Boolean.getBoolean(PROPERTY_DONT_USE_SUBSTANCE_RENDERERS);
        }
        catch (AccessControlException ace) {
            use = true;
        }
        USE_SUBSTANCE_RENDERERS = use;
    }
}

