/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;

public class SquiggleUnderlineHighlightPainter
extends ChangeableHighlightPainter {
    private static final int AMT = 2;

    public SquiggleUnderlineHighlightPainter(Color color) {
        super(color);
        this.setPaint(color);
    }

    @Override
    public Shape paintLayer(Graphics g15, int offs0, int offs1, Shape bounds, JTextComponent c15, View view) {
        g15.setColor((Color)this.getPaint());
        if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
            Rectangle alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            this.paintSquiggle(g15, alloc);
            return alloc;
        }
        try {
            Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
            Rectangle r15 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            this.paintSquiggle(g15, r15);
            return r15;
        }
        catch (BadLocationException e15) {
            e15.printStackTrace();
            return null;
        }
    }

    protected void paintSquiggle(Graphics g15, Rectangle r15) {
        int y15 = r15.y + r15.height - 2;
        int delta = -2;
        for (int x15 = r15.x; x15 < r15.x + r15.width; x15 += 2) {
            g15.drawLine(x15, y15, x15 + 2, y15 + delta);
            y15 += delta;
            delta = -delta;
        }
    }
}

