/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.focusabletip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import org.fife.ui.rsyntaxtextarea.HtmlUtil;
import org.fife.ui.rsyntaxtextarea.focusabletip.FocusableTip;
import org.fife.ui.rsyntaxtextarea.focusabletip.SizeGrip;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipUtil;

class TipWindow
extends JWindow {
    private FocusableTip ft;
    private JEditorPane textArea;
    private transient TipListener tipListener;
    private transient HyperlinkListener userHyperlinkListener;
    private static TipWindow visibleInstance;
    private static final String FLAT_LAF_BORDER_PREFIX = "com.formdev.flatlaf.ui.Flat";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TipWindow(Window owner, FocusableTip ft4, String msg) {
        super(owner);
        this.ft = ft4;
        if (msg != null && msg.length() >= 6 && !msg.substring(0, 6).equalsIgnoreCase("<html>")) {
            msg = "<html>" + HtmlUtil.escapeForHtml(msg, "<br>", false);
        }
        this.tipListener = new TipListener();
        JPanel cp4 = new JPanel(new BorderLayout());
        cp4.setBorder(TipWindow.getToolTipBorder());
        cp4.setBackground(TipUtil.getToolTipBackground());
        this.textArea = new JEditorPane("text/html", msg);
        TipUtil.tweakTipEditorPane(this.textArea);
        if (ft4.getImageBase() != null) {
            ((HTMLDocument)this.textArea.getDocument()).setBase(ft4.getImageBase());
        }
        this.textArea.addMouseListener(this.tipListener);
        this.textArea.addHyperlinkListener(e15 -> {
            if (e15.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.ft.possiblyDisposeOfTipWindow();
            }
        });
        cp4.add(this.textArea);
        this.setFocusableWindowState(false);
        this.setContentPane(cp4);
        this.setBottomPanel();
        this.pack();
        KeyAdapter ka5 = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e15) {
                if (e15.getKeyCode() == 27) {
                    TipWindow.this.ft.possiblyDisposeOfTipWindow();
                }
            }
        };
        this.addKeyListener(ka5);
        this.textArea.addKeyListener(ka5);
        Class<TipWindow> clazz = TipWindow.class;
        synchronized (TipWindow.class) {
            if (visibleInstance != null) {
                visibleInstance.dispose();
            }
            visibleInstance = this;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    public void actionPerformed() {
        if (!this.getFocusableWindowState()) {
            this.setFocusableWindowState(true);
            this.setBottomPanel();
            this.textArea.removeMouseListener(this.tipListener);
            this.pack();
            this.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowLostFocus(WindowEvent e15) {
                    TipWindow.this.ft.possiblyDisposeOfTipWindow();
                }
            });
            this.ft.removeListeners();
            this.requestFocus();
        }
    }

    @Override
    public void dispose() {
        Container cp4 = this.getContentPane();
        for (int i15 = 0; i15 < cp4.getComponentCount(); ++i15) {
            cp4.getComponent(i15).removeMouseListener(this.tipListener);
        }
        this.ft.removeListeners();
        super.dispose();
    }

    void fixSize() {
        try {
            Rectangle r15 = this.textArea.modelToView(this.textArea.getDocument().getLength() - 1);
            Dimension d15 = this.textArea.getPreferredSize();
            d15.width += 25;
            int maxWindowW = this.ft.getMaxSize() != null ? this.ft.getMaxSize().width : 600;
            int maxWindowH = this.ft.getMaxSize() != null ? this.ft.getMaxSize().height : 400;
            d15.width = Math.min(d15.width, maxWindowW);
            d15.height = Math.min(d15.height, maxWindowH);
            this.textArea.setPreferredSize(d15);
            this.textArea.setSize(d15);
            r15 = this.textArea.modelToView(this.textArea.getDocument().getLength() - 1);
            if (r15.y + r15.height > d15.height) {
                d15.height = r15.y + r15.height + 5;
                if (this.ft.getMaxSize() != null) {
                    d15.height = Math.min(d15.height, maxWindowH);
                }
                this.textArea.setPreferredSize(d15);
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        this.pack();
    }

    private static Border getReplacementForFlatLafBorder(Border border) {
        Method[] methods2;
        Class<?> clazz = border.getClass();
        Color color = null;
        for (Method method : methods2 = clazz.getDeclaredMethods()) {
            if (!"getLineColor".equals(method.getName())) continue;
            try {
                color = (Color)method.invoke((Object)border, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e15) {
                e15.printStackTrace();
            }
        }
        if (color != null) {
            return BorderFactory.createLineBorder(color);
        }
        return BorderFactory.createEmptyBorder();
    }

    protected String getText() {
        return this.textArea.getText();
    }

    private static Border getToolTipBorder() {
        Border border = TipUtil.getToolTipBorder();
        if (TipWindow.isFlatLafBorder(border)) {
            border = TipWindow.getReplacementForFlatLafBorder(border);
        }
        return border;
    }

    private static boolean isFlatLafBorder(Border border) {
        return border != null && border.getClass().getName().startsWith(FLAT_LAF_BORDER_PREFIX);
    }

    private void setBottomPanel() {
        final JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JSeparator(), "North");
        boolean focusable = this.getFocusableWindowState();
        if (focusable) {
            SizeGrip sg5 = new SizeGrip();
            sg5.applyComponentOrientation(sg5.getComponentOrientation());
            panel.add((Component)sg5, "After");
            MouseInputAdapter adapter = new MouseInputAdapter(){
                private Point lastPoint;

                @Override
                public void mouseDragged(MouseEvent e15) {
                    Point p15 = e15.getPoint();
                    SwingUtilities.convertPointToScreen(p15, panel);
                    if (this.lastPoint != null) {
                        int dx4 = p15.x - this.lastPoint.x;
                        int dy4 = p15.y - this.lastPoint.y;
                        TipWindow.this.setLocation(TipWindow.this.getX() + dx4, TipWindow.this.getY() + dy4);
                    }
                    this.lastPoint = p15;
                }

                @Override
                public void mousePressed(MouseEvent e15) {
                    this.lastPoint = e15.getPoint();
                    SwingUtilities.convertPointToScreen(this.lastPoint, panel);
                }
            };
            panel.addMouseListener(adapter);
            panel.addMouseMotionListener(adapter);
        } else {
            panel.setOpaque(false);
            JLabel label = new JLabel(FocusableTip.getString("FocusHotkey"));
            Color fg5 = UIManager.getColor("Label.disabledForeground");
            Font font = this.textArea.getFont();
            font = font.deriveFont(font.getSize2D() - 1.0f);
            label.setFont(font);
            if (fg5 == null) {
                fg5 = Color.GRAY;
            }
            label.setOpaque(true);
            Color bg5 = TipUtil.getToolTipBackground();
            label.setBackground(bg5);
            label.setForeground(fg5);
            label.setHorizontalAlignment(11);
            label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            panel.add(label);
            panel.addMouseListener(this.tipListener);
        }
        Container cp4 = this.getContentPane();
        if (cp4.getComponentCount() == 2) {
            Component comp = cp4.getComponent(0);
            cp4.remove(0);
            JScrollPane sp4 = new JScrollPane(comp);
            Border emptyBorder = BorderFactory.createEmptyBorder();
            sp4.setBorder(emptyBorder);
            sp4.setViewportBorder(emptyBorder);
            sp4.setBackground(this.textArea.getBackground());
            sp4.getViewport().setBackground(this.textArea.getBackground());
            cp4.add(sp4);
            cp4.getComponent(0).removeMouseListener(this.tipListener);
            cp4.remove(0);
        }
        cp4.add((Component)panel, "South");
    }

    public void setHyperlinkListener(HyperlinkListener listener) {
        if (this.userHyperlinkListener != null) {
            this.textArea.removeHyperlinkListener(this.userHyperlinkListener);
        }
        this.userHyperlinkListener = listener;
        if (this.userHyperlinkListener != null) {
            this.textArea.addHyperlinkListener(this.userHyperlinkListener);
        }
    }

    private final class TipListener
    extends MouseAdapter {
        private TipListener() {
        }

        @Override
        public void mousePressed(MouseEvent e15) {
            TipWindow.this.actionPerformed();
        }

        @Override
        public void mouseExited(MouseEvent e15) {
            Component source = (Component)e15.getSource();
            Point p15 = e15.getPoint();
            SwingUtilities.convertPointToScreen(p15, source);
            if (!TipWindow.this.getBounds().contains(p15)) {
                TipWindow.this.ft.possiblyDisposeOfTipWindow();
            }
        }
    }
}

