/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.compiler;

import java.util.ArrayList;
import org.stringtemplate.v4.compiler.Bytecode;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.misc.Interval;
import org.stringtemplate.v4.misc.Misc;

public class BytecodeDisassembler {
    CompiledST code;

    public BytecodeDisassembler(CompiledST code) {
        this.code = code;
    }

    public String instrs() {
        StringBuilder buf = new StringBuilder();
        int ip4 = 0;
        while (ip4 < this.code.codeSize) {
            if (ip4 > 0) {
                buf.append(", ");
            }
            byte opcode = this.code.instrs[ip4];
            Bytecode.Instruction I11 = Bytecode.instructions[opcode];
            buf.append(I11.name);
            ++ip4;
            for (int opnd = 0; opnd < I11.nopnds; ++opnd) {
                buf.append(' ');
                buf.append(BytecodeDisassembler.getShort(this.code.instrs, ip4));
                ip4 += 2;
            }
        }
        return buf.toString();
    }

    public String disassemble() {
        StringBuilder buf = new StringBuilder();
        int i15 = 0;
        while (i15 < this.code.codeSize) {
            i15 = this.disassembleInstruction(buf, i15);
            buf.append('\n');
        }
        return buf.toString();
    }

    public int disassembleInstruction(StringBuilder buf, int ip4) {
        int i15;
        byte opcode = this.code.instrs[ip4];
        if (ip4 >= this.code.codeSize) {
            throw new IllegalArgumentException("ip out of range: " + ip4);
        }
        Bytecode.Instruction I11 = Bytecode.instructions[opcode];
        if (I11 == null) {
            throw new IllegalArgumentException("no such instruction " + opcode + " at address " + ip4);
        }
        String instrName = I11.name;
        buf.append(String.format("%04d:\t%-14s", ip4, instrName));
        ++ip4;
        if (I11.nopnds == 0) {
            buf.append("  ");
            return ip4;
        }
        ArrayList<String> operands = new ArrayList<String>();
        block4: for (i15 = 0; i15 < I11.nopnds; ++i15) {
            int opnd = BytecodeDisassembler.getShort(this.code.instrs, ip4);
            ip4 += 2;
            switch (I11.type[i15]) {
                case STRING: {
                    operands.add(this.showConstPoolOperand(opnd));
                    continue block4;
                }
                case ADDR: 
                case INT: {
                    operands.add(String.valueOf(opnd));
                    continue block4;
                }
                default: {
                    operands.add(String.valueOf(opnd));
                }
            }
        }
        for (i15 = 0; i15 < operands.size(); ++i15) {
            String s15 = (String)operands.get(i15);
            if (i15 > 0) {
                buf.append(", ");
            }
            buf.append(s15);
        }
        return ip4;
    }

    private String showConstPoolOperand(int poolIndex) {
        StringBuilder buf = new StringBuilder();
        buf.append("#");
        buf.append(poolIndex);
        String s15 = "<bad string index>";
        if (poolIndex < this.code.strings.length) {
            if (this.code.strings[poolIndex] == null) {
                s15 = "null";
            } else {
                s15 = this.code.strings[poolIndex].toString();
                if (this.code.strings[poolIndex] instanceof String) {
                    s15 = Misc.replaceEscapes(s15);
                    s15 = '\"' + s15 + '\"';
                }
            }
        }
        buf.append(":");
        buf.append(s15);
        return buf.toString();
    }

    public static int getShort(byte[] memory, int index) {
        int b15 = memory[index] & 0xFF;
        int b25 = memory[index + 1] & 0xFF;
        int word = b15 << 8 | b25;
        return word;
    }

    public String strings() {
        StringBuilder buf = new StringBuilder();
        int addr = 0;
        if (this.code.strings != null) {
            for (String o15 : this.code.strings) {
                if (o15 instanceof String) {
                    String s15 = o15;
                    s15 = Misc.replaceEscapes(s15);
                    buf.append(String.format("%04d: \"%s\"\n", addr, s15));
                } else {
                    buf.append(String.format("%04d: %s\n", addr, o15));
                }
                ++addr;
            }
        }
        return buf.toString();
    }

    public String sourceMap() {
        StringBuilder buf = new StringBuilder();
        int addr = 0;
        for (Interval I11 : this.code.sourceMap) {
            if (I11 != null) {
                String chunk = this.code.template.substring(I11.a, I11.b + 1);
                buf.append(String.format("%04d: %s\t\"%s\"\n", addr, I11, chunk));
            }
            ++addr;
        }
        return buf.toString();
    }
}

