/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.misc;

import org.stringtemplate.v4.InstanceScope;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.misc.Coordinate;
import org.stringtemplate.v4.misc.ErrorType;
import org.stringtemplate.v4.misc.Interval;
import org.stringtemplate.v4.misc.Misc;
import org.stringtemplate.v4.misc.STMessage;

public class STRuntimeMessage
extends STMessage {
    final Interpreter interp;
    public final int ip;
    public final InstanceScope scope;

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip4) {
        this(interp, error, ip4, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip4, InstanceScope scope) {
        this(interp, error, ip4, scope, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip4, InstanceScope scope, Object arg) {
        this(interp, error, ip4, scope, null, arg, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip4, InstanceScope scope, Throwable e15, Object arg) {
        this(interp, error, ip4, scope, e15, arg, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip4, InstanceScope scope, Throwable e15, Object arg, Object arg2) {
        this(interp, error, ip4, scope, e15, arg, arg2, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip4, InstanceScope scope, Throwable e15, Object arg, Object arg2, Object arg3) {
        super(error, scope != null ? scope.st : null, e15, arg, arg2, arg3);
        this.interp = interp;
        this.ip = ip4;
        this.scope = scope;
    }

    public String getSourceLocation() {
        if (this.ip < 0 || this.self.impl == null) {
            return null;
        }
        Interval I11 = this.self.impl.sourceMap[this.ip];
        if (I11 == null) {
            return null;
        }
        int i15 = I11.a;
        Coordinate loc = Misc.getLineCharPosition(this.self.impl.template, i15);
        return loc.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String loc = this.getSourceLocation();
        if (this.self != null) {
            buf.append("context [");
            if (this.interp != null) {
                buf.append(Interpreter.getEnclosingInstanceStackString(this.scope));
            }
            buf.append("]");
        }
        if (loc != null) {
            buf.append(" " + loc);
        }
        buf.append(" " + super.toString());
        return buf.toString();
    }
}

