/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shadow.bundletool.com.android.utils.CpuArchitecture;
import shadow.bundletool.com.android.utils.Environment;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0010\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0001\u001a\b\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\b\u0010\u0010\u001a\u00020\u0011H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0012"}, d2={"OS_LINUX_PREFIX", "", "OS_MAC_PREFIX", "OS_WIN_PREFIX", "TRANSLATED", "", "jvmArchitecture", "Lshadow/bundletool/com/android/utils/CpuArchitecture;", "getJvmArchitecture", "()Lcom/android/utils/CpuArchitecture;", "osArchitecture", "getOsArchitecture", "architectureFromString", "cpuArchName", "computeIsRosetta", "", "ensureInitialized", "", "common"})
public final class ComputerArchUtilsKt {
    @NotNull
    private static final String OS_MAC_PREFIX = "mac";
    @NotNull
    private static final String OS_WIN_PREFIX = "win";
    @NotNull
    private static final String OS_LINUX_PREFIX = "linux";
    private static final int TRANSLATED = 1;

    private static final void ensureInitialized() {
        if (!Environment.Companion.getInitialized()) {
            Environment.Companion.initialize$default(Environment.Companion, null, 1, null);
        }
    }

    @NotNull
    public static final CpuArchitecture getJvmArchitecture() {
        ComputerArchUtilsKt.ensureInitialized();
        String arch = Environment.Companion.getInstance().getSystemProperty(Environment.SystemProperty.OS_ARCH);
        return ComputerArchUtilsKt.architectureFromString(arch);
    }

    @NotNull
    public static final CpuArchitecture getOsArchitecture() {
        String string;
        CpuArchitecture jvmArchitecture;
        block11: {
            block10: {
                jvmArchitecture = ComputerArchUtilsKt.getJvmArchitecture();
                String string2 = Environment.Companion.getInstance().getSystemProperty(Environment.SystemProperty.OS_NAME);
                if (string2 == null) break block10;
                String string3 = string2;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue(locale, "US");
                String string4 = string3.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
                string = string4;
                if (string != null) break block11;
            }
            return jvmArchitecture;
        }
        String os4 = string;
        if (jvmArchitecture == CpuArchitecture.X86) {
            if (StringsKt.startsWith$default(os4, OS_WIN_PREFIX, false, 2, null)) {
                String w6432 = Environment.Companion.getInstance().getVariable(Environment.EnvironmentVariable.PROCESSOR_ARCHITEW6432);
                if (w6432 != null && StringsKt.contains$default((CharSequence)w6432, "64", false, 2, null)) {
                    return CpuArchitecture.X86_64;
                }
            } else if (StringsKt.startsWith$default(os4, OS_LINUX_PREFIX, false, 2, null)) {
                String hostType = Environment.Companion.getInstance().getVariable(Environment.EnvironmentVariable.HOST_TYPE);
                return ComputerArchUtilsKt.architectureFromString(hostType);
            }
        }
        if (jvmArchitecture == CpuArchitecture.X86_64 && StringsKt.startsWith$default(os4, OS_MAC_PREFIX, false, 2, null) && Environment.Companion.getInstance().isRosetta()) {
            return CpuArchitecture.X86_ON_ARM;
        }
        return jvmArchitecture;
    }

    private static final boolean computeIsRosetta() {
        Object object;
        Object e152;
        Object e162;
        Field e172;
        Class<?> clazz;
        try {
            Class<?> clazz2 = Class.forName("com.sun.jna.platform.mac.SystemB");
            Class<Object> clazz3 = clazz2 instanceof Class ? clazz2 : null;
            if (clazz3 == null) {
                return false;
            }
            clazz = clazz3;
        }
        catch (ClassNotFoundException e18) {
            return false;
        }
        catch (LinkageError e172) {
            return false;
        }
        Class<?> clazz4 = clazz;
        try {
            e172 = clazz4.getField("INSTANCE");
        }
        catch (NoSuchFieldException e162) {
            return false;
        }
        Field instanceField = e172;
        try {
            e162 = instanceField.get(null);
        }
        catch (IllegalArgumentException e152) {
            return false;
        }
        Object instance = e162;
        try {
            e152 = new Class[]{String.class, Pointer.class, IntByReference.class, Pointer.class, Integer.TYPE};
            e152 = clazz4.getMethod("sysctlbyname", (Class<?>)e152);
        }
        catch (NoSuchMethodException e19) {
            return false;
        }
        Object sysctlbyname = e152;
        Memory memory = new Memory(4L);
        IntByReference retSize = new IntByReference(4);
        try {
            object = new Object[]{"sysctl.proc_translated", memory, retSize, null, 0};
            object = ((Method)sysctlbyname).invoke(instance, object);
        }
        catch (Exception e25) {
            return false;
        }
        Object errorCode = object;
        return Intrinsics.areEqual(errorCode, (Object)0) && memory.getInt(0L) == 1;
    }

    @NotNull
    public static final CpuArchitecture architectureFromString(@Nullable String cpuArchName) {
        CharSequence charSequence = cpuArchName;
        return charSequence == null || charSequence.length() == 0 ? CpuArchitecture.UNKNOWN : (StringsKt.equals(cpuArchName, "x86_64", true) ? CpuArchitecture.X86_64 : (StringsKt.equals(cpuArchName, "ia64", true) ? CpuArchitecture.X86_64 : (StringsKt.equals(cpuArchName, "amd64", true) ? CpuArchitecture.X86_64 : (StringsKt.equals(cpuArchName, "x86", true) ? CpuArchitecture.X86 : (StringsKt.equals(cpuArchName, "aarch64", true) ? CpuArchitecture.ARM : (StringsKt.equals(cpuArchName, "arm64", true) ? CpuArchitecture.ARM : (cpuArchName.length() == 4 && cpuArchName.charAt(0) == 'i' && StringsKt.endsWith$default(cpuArchName, "86", false, 2, null) ? CpuArchitecture.X86 : CpuArchitecture.UNKNOWN)))))));
    }

    public static final /* synthetic */ boolean access$computeIsRosetta() {
        return ComputerArchUtilsKt.computeIsRosetta();
    }
}

