/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import javajs.util.Lst;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jspecview.api.JSVFileDropper;
import jspecview.api.JSVPanel;
import jspecview.api.JSVTreeNode;
import jspecview.api.PanelListener;
import jspecview.application.AppToolBar;
import jspecview.application.ApplicationMenu;
import jspecview.application.AwtTree;
import jspecview.application.CommandHistory;
import jspecview.application.DisplaySchemesProcessor;
import jspecview.application.JSpecView;
import jspecview.application.PreferencesDialog;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PanelNode;
import jspecview.common.PeakPickEvent;
import jspecview.common.ScriptToken;
import jspecview.common.SubSpecChangeEvent;
import jspecview.common.ZoomEvent;
import jspecview.export.Exporter;
import jspecview.source.JDXSource;
import org.jmol.api.JSVInterface;

public class MainFrame
extends JFrame
implements PanelListener {
    private static final long serialVersionUID = 1L;
    private static final int MAX_RECENT = 10;
    private static final int JMOL_MIN_HEIGHT = 130;
    JSViewer vwr;
    private JSpecView jsv;
    ApplicationMenu appMenu;
    private AppToolBar toolBar;
    private JTextField commandInput = new JTextField();
    private BorderLayout mainborderLayout = new BorderLayout();
    private JSplitPane mainSplitPane = new JSplitPane();
    private final JPanel nullPanel = new JPanel();
    private JSplitPane sideSplitPane = new JSplitPane();
    private CommandHistory commandHistory;
    private DisplaySchemesProcessor dsp;
    private Component jmolDisplay;
    private Dimension jmolDimensionOld;
    private JPanel jmolPanel;
    private Dimension jmolDimensionNew = new Dimension(350, 300);
    private Lst<String> recentFilePaths = new Lst();
    private JScrollPane spectraTreeScrollPane;
    private Component mainPanel;
    private JPanel statusPanel = new JPanel();
    private JLabel statusLabel = new JLabel();
    private AwtTree tree;
    private boolean sidePanelOn;
    private boolean showExitDialog;
    private boolean statusbarOn;
    private boolean toolbarOn;
    private int mainSplitPosition = 200;
    private int splitPosition;
    private boolean isHidden;
    private String tempDS;
    private boolean isAwake;
    private int jmolFrameHeight;
    private int jmolFrameWidth;

    public static void main(String[] args) {
        JSpecView.main(args);
    }

    public MainFrame(JSpecView jsv, Component jmolDisplay, JSVInterface jmolStatusListener) {
        this.jsv = jsv;
        this.vwr = jsv.vwr;
        this.jmolDisplay = jmolDisplay;
        if (jmolDisplay != null) {
            this.jmolPanel = (JPanel)jmolDisplay.getParent();
        }
        jsv.setStatusListener(jmolStatusListener);
        this.init();
    }

    void exitJSpecView(boolean withDialog, boolean isClosing) {
        this.jsv.notifyExitingJspecView(isClosing, withDialog && this.showExitDialog);
    }

    public void awaken(boolean visible) {
        if (!this.vwr.isEmbedded) {
            return;
        }
        System.out.println("MAINFRAME visible/awake" + visible + " " + this.isAwake + " " + this.jmolDisplay);
        if (this.isAwake == visible) {
            return;
        }
        this.jsv.vwr.setRecentSimulation(null);
        this.isAwake = visible;
        if (this.jmolDisplay != null) {
            try {
                Container top = this.jmolPanel.getTopLevelAncestor();
                if (visible) {
                    this.jmolDimensionOld = new Dimension(0, 0);
                    this.jmolDisplay.getSize(this.jmolDimensionOld);
                    this.jmolDisplay.setSize(this.jmolDimensionNew);
                    this.jmolPanel.remove(this.jmolDisplay);
                    if (top.getHeight() > 130) {
                        this.jmolFrameHeight = top.getHeight();
                        this.jmolFrameWidth = top.getWidth();
                        top.setSize(this.jmolFrameWidth, 130);
                    }
                    this.jmolPanel.add(this.nullPanel);
                    this.sideSplitPane.setBottomComponent(this.jmolDisplay);
                    this.sideSplitPane.setDividerLocation(this.splitPosition);
                    this.sideSplitPane.validate();
                    this.jmolPanel.validate();
                    System.out.println("awakened");
                } else {
                    this.sideSplitPane.setBottomComponent(this.nullPanel);
                    this.splitPosition = this.sideSplitPane.getDividerLocation();
                    this.jmolPanel.add(this.jmolDisplay);
                    if (top.getHeight() <= 130) {
                        top.setSize(this.jmolFrameWidth, this.jmolFrameHeight);
                    }
                    this.jmolDisplay.getSize(this.jmolDimensionNew);
                    this.jmolDisplay.setSize(this.jmolDimensionOld);
                    this.sideSplitPane.validate();
                    this.jmolPanel.validate();
                    System.out.println("sleeping");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.setVisible(visible);
    }

    private void init() {
        DropTargetListener dtl = (DropTargetListener)this.vwr.getPlatformInterface("FileDropper");
        ((JSVFileDropper)((Object)dtl)).set(this.vwr);
        new DropTarget(this, dtl);
        Class<?> cl = this.getClass();
        URL iconURL = cl.getResource("icons/spec16.gif");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(iconURL));
        this.setApplicationProperties(true);
        this.tempDS = this.jsv.defaultDisplaySchemeName;
        this.tree = new AwtTree(this.vwr);
        this.vwr.spectraTree = this.tree;
        this.tree.setCellRenderer(new SpectraTreeCellRenderer());
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setShowsRootHandles(true);
        this.tree.setEditable(false);
        this.tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && MainFrame.this.vwr.selectedPanel != null) {
                    MainFrame.this.vwr.selectedPanel.getPanelData().setZoom(0.0, 0.0, 0.0, 0.0);
                    MainFrame.this.repaint();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        new DropTarget(this.tree, dtl);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setApplicationElements();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                MainFrame.this.windowClosing_actionPerformed();
            }

            @Override
            public void windowIconified(WindowEvent we) {
                MainFrame.this.windowIconified_actionPerformed();
            }
        });
        this.setSize(1200, 800);
    }

    private void setApplicationElements() {
        this.appMenu.setSelections(this.sidePanelOn, this.toolbarOn, this.statusbarOn, this.vwr.selectedPanel);
        this.toolBar.setSelections(this.vwr.selectedPanel);
    }

    private void setApplicationProperties(boolean shouldApplySpectrumDisplaySettings) {
        Properties properties = this.vwr.properties;
        String recentFilesString = properties.getProperty("recentFilePaths");
        this.recentFilePaths.clear();
        if (!recentFilesString.equals("")) {
            StringTokenizer st = new StringTokenizer(recentFilesString, ",");
            while (st.hasMoreTokens()) {
                String file = st.nextToken().trim();
                if (file.length() >= 100) continue;
                this.recentFilePaths.addLast(file);
            }
        }
        this.showExitDialog = Boolean.parseBoolean(properties.getProperty("confirmBeforeExit"));
        this.sidePanelOn = Boolean.parseBoolean(properties.getProperty("showSidePanel"));
        this.toolbarOn = Boolean.parseBoolean(properties.getProperty("showToolBar"));
        this.statusbarOn = Boolean.parseBoolean(properties.getProperty("showStatusBar"));
        this.jsv.setApplicationProperties(shouldApplySpectrumDisplaySettings);
    }

    private void jbInit() throws Exception {
        this.toolBar = new AppToolBar(this);
        this.appMenu = new ApplicationMenu(this);
        this.appMenu.setRecentMenu(this.recentFilePaths);
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(this.appMenu);
        this.setTitle("JSpecView");
        this.getContentPane().setLayout(this.mainborderLayout);
        this.sideSplitPane.setOrientation(0);
        this.sideSplitPane.setOneTouchExpandable(true);
        this.statusLabel.setToolTipText("");
        this.statusLabel.setHorizontalTextPosition(10);
        this.statusLabel.setText("  ");
        this.statusPanel.setBorder(BorderFactory.createEtchedBorder());
        BorderLayout bl = new BorderLayout();
        bl.setHgap(2);
        bl.setVgap(2);
        this.statusPanel.setLayout(bl);
        this.mainSplitPane.setCursor(Cursor.getDefaultCursor());
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setResizeWeight(0.3);
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.statusPanel.add((Component)this.statusLabel, "North");
        this.statusPanel.add((Component)this.commandInput, "South");
        this.commandHistory = new CommandHistory(this.vwr, this.commandInput);
        this.commandInput.setFocusTraversalKeysEnabled(false);
        this.commandInput.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                MainFrame.this.keyPressedEvent(e.getKeyCode(), e.getKeyChar());
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
        this.spectraTreeScrollPane = new JScrollPane(this.tree);
        if (this.jmolDisplay != null) {
            JSplitPane leftPanel = new JSplitPane();
            BorderLayout bl1 = new BorderLayout();
            leftPanel.setLayout(bl1);
            JPanel jmolDisplayPanel = new JPanel();
            jmolDisplayPanel.setBackground(Color.BLACK);
            leftPanel.add((Component)jmolDisplayPanel, "South");
            leftPanel.add((Component)this.spectraTreeScrollPane, "North");
            this.sideSplitPane.setTopComponent(this.spectraTreeScrollPane);
            this.splitPosition = 300;
            this.sideSplitPane.setDividerLocation(300);
            this.awaken(true);
            this.mainSplitPane.setLeftComponent(this.sideSplitPane);
        } else {
            this.mainSplitPane.setLeftComponent(this.spectraTreeScrollPane);
        }
        this.mainPanel = (Component)((Object)this.vwr.mainPanel);
        this.mainSplitPane.setRightComponent(this.mainPanel);
    }

    protected void keyPressedEvent(int keyCode, char keyChar) {
        this.commandHistory.keyPressed(keyCode);
        String ret = this.vwr.checkCommandLineForTip(keyChar, this.commandInput.getText(), true);
        if (ret != null) {
            this.commandInput.setText(ret);
        }
        this.commandInput.requestFocusInWindow();
    }

    void setError(boolean isError, boolean isWarningOnly) {
        this.appMenu.setError(isError, isWarningOnly);
        this.toolBar.setError(isError, isWarningOnly);
    }

    void showNotImplementedOptionPane() {
        if (this.vwr.hasDisplay) {
            JOptionPane.showMessageDialog(this, "Not Yet Implemented", "Not Yet Implemented", 1);
        }
    }

    @Override
    public void panelEvent(Object eventObj) {
        SubSpecChangeEvent e;
        if (eventObj instanceof PeakPickEvent) {
            this.vwr.processPeakPickEvent(eventObj, true);
        } else if (eventObj instanceof ZoomEvent) {
            this.writeStatus("Double-Click highlighted spectrum in menu to zoom out; CTRL+/CTRL- to adjust Y scaling.");
        } else if (eventObj instanceof SubSpecChangeEvent && !(e = (SubSpecChangeEvent)eventObj).isValid()) {
            this.vwr.advanceSpectrumBy(-e.getSubIndex());
        }
    }

    void setSplitPane(boolean TF) {
        if (TF) {
            this.mainSplitPane.setDividerLocation(200);
        } else {
            this.mainSplitPane.setDividerLocation(0);
        }
    }

    void enableToolbar(boolean isEnabled) {
        if (isEnabled) {
            this.getContentPane().add((Component)this.toolBar, "North");
        } else {
            this.getContentPane().remove(this.toolBar);
        }
        this.validate();
    }

    void showPreferences() {
        PreferencesDialog pd = new PreferencesDialog(this, this.vwr, "Preferences", true, this.dsp);
        this.vwr.properties = pd.getPreferences();
        boolean shouldApplySpectrumDisplaySetting = pd.shouldApplySpectrumDisplaySettingsNow();
        this.setApplicationProperties(shouldApplySpectrumDisplaySetting);
        int i = this.vwr.panelNodes.size();
        while (--i >= 0) {
            this.jsv.siSetPropertiesFromPreferences(((PanelNode)this.vwr.panelNodes.get((int)i)).jsvp, shouldApplySpectrumDisplaySetting);
        }
        this.setApplicationElements();
        this.dsp.getDisplaySchemes();
        if (this.jsv.defaultDisplaySchemeName.equals("Current")) {
            this.vwr.setProperty("defaultDisplaySchemeName", this.tempDS);
        }
    }

    void exportSpectrumViaMenu(String command) {
        new Exporter().write(this.vwr, ScriptToken.getTokens(command), false);
    }

    void enableStatus(boolean TF) {
        if (TF) {
            this.getContentPane().add((Component)this.statusPanel, "South");
        } else {
            this.getContentPane().remove(this.statusPanel);
        }
        this.validate();
    }

    protected void windowClosing_actionPerformed() {
        this.exitJSpecView(true, true);
    }

    protected void windowIconified_actionPerformed() {
        if (this.jsv.jmol == null) {
            return;
        }
        this.setState(0);
        this.isHidden = true;
        this.setVisible(!this.isHidden);
        this.exitJSpecView(false, false);
    }

    void updateToolbar(ScriptToken st, boolean tf) {
        if (this.vwr.selectedPanel != null) {
            switch (st) {
                case COORDINATESON: {
                    this.toolBar.coordsToggleButton.setSelected(tf);
                    break;
                }
                case GRIDON: {
                    this.toolBar.gridToggleButton.setSelected(tf);
                    break;
                }
            }
        }
    }

    void sourceClosed(JDXSource source) {
        this.appMenu.clearSourceMenu(source);
        this.setTitle("JSpecView");
        this.validateAndRepaint(false);
    }

    void setLoading(String fileName, String filePath) {
        this.appMenu.setCloseMenuItem(fileName);
        this.setTitle("JSpecView - " + (filePath.startsWith("http://SIMULATION/") ? JSVFileManager.getSimulationType(filePath) + " SIMULATION" : filePath));
        this.appMenu.setSourceEnabled(true);
    }

    void updateRecentMenus(String filePath) {
        if (filePath.length() > 100) {
            return;
        }
        if (this.recentFilePaths.size() >= 10) {
            this.recentFilePaths.removeItemAt(9);
        }
        if (this.recentFilePaths.contains(filePath)) {
            this.recentFilePaths.removeObj(filePath);
        }
        this.recentFilePaths.add(0, filePath);
        SB filePaths = new SB();
        int n = this.recentFilePaths.size();
        for (int index = 0; index < n; ++index) {
            filePaths.append(", ").append((String)this.recentFilePaths.get(index));
        }
        this.vwr.setProperty("recentFilePaths", n == 0 ? "" : filePaths.substring(2));
        this.appMenu.updateRecentMenus(this.recentFilePaths);
    }

    void setMenuEnables(PanelNode node, boolean isSplit) {
        this.appMenu.setMenuEnables(node);
        this.toolBar.setMenuEnables(node);
    }

    void setSelectedPanel(JSVPanel jsvp) {
        if (this.vwr.selectedPanel != null) {
            this.mainSplitPosition = this.mainSplitPane.getDividerLocation();
        }
        this.vwr.mainPanel.setSelectedPanel(this.vwr, jsvp, this.vwr.panelNodes);
        this.vwr.spectraTree.setSelectedPanel(this.jsv, jsvp);
        this.validate();
        if (jsvp != null) {
            jsvp.setEnabled(true);
            jsvp.setFocusable(true);
        }
        if (this.mainSplitPosition != 0) {
            this.mainSplitPane.setDividerLocation(this.mainSplitPosition);
        }
    }

    void validateAndRepaint(boolean isAll) {
        this.validate();
        if (isAll) {
            this.repaint();
        } else {
            this.vwr.requestRepaint();
        }
    }

    void execHidden(boolean b) {
        this.isHidden = this.jsv.jmol != null && b;
        this.setVisible(!this.isHidden);
    }

    void writeStatus(String msg) {
        if (msg == null) {
            msg = "Unexpected Error";
        }
        if (msg.length() == 0) {
            msg = "Enter a command:";
        }
        this.statusLabel.setText(msg);
    }

    void setTreeEnabled(boolean b) {
        this.tree.setEnabled(b);
    }

    void closeMenuItem(JDXSource source) {
        if (source != null) {
            this.appMenu.setCloseMenuItem(JSVFileManager.getTagName(source.getFilePath()));
        }
        boolean isError = source != null && source.getErrorLog().length() > 0;
        this.setError(isError, isError && source.getErrorLog().indexOf("Warning") >= 0);
    }

    private class SpectraTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        JSVTreeNode node;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.node = (JSVTreeNode)value;
            return this;
        }

        @Override
        public Font getFont() {
            return new Font("Dialog", this.node == null || this.node.getPanelNode() == null || this.node.getPanelNode().jsvp == null ? 1 : 2, 12);
        }
    }
}

