/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.janocchio;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.openscience.jmol.app.janocchio.NMR_JmolPanel;

class NmrReaderThread
extends Thread {
    File file;
    NMR_JmolPanel nmr;

    NmrReaderThread(File file, NMR_JmolPanel nmr) {
        this.file = file;
        this.nmr = nmr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        BufferedReader inp = null;
        try {
            int j;
            int opt;
            inp = new BufferedReader(new FileReader(this.file));
            String currentStructureFile = this.nmr.getCurrentStructureFile();
            String line = inp.readLine().trim();
            if (currentStructureFile == null) {
                opt = JOptionPane.showConfirmDialog((Component)((Object)this.nmr), "No Structure File currently loaded.\nLoad Structure File " + line + "\ndefined in this NMR Data File?", "No Structure Warning", 0);
                if (opt != 0) return;
                this.nmr.vwr.scriptWait("load " + line);
                this.nmr.vwr.openFile(line);
            } else if (!currentStructureFile.equals(line) && (opt = JOptionPane.showConfirmDialog((Component)((Object)this.nmr), "This NMR Data file was saved from a different structure file from that currently loaded.\nContinue Reading Data?", "Read NMR Data Warning", 0)) == 1) {
                return;
            }
            String command = new String();
            while ((line = inp.readLine()).trim().length() != 0) {
                String[] l = line.split("\\s+");
                int i = new Integer(l[0]);
                String com = this.nmr.labelSetter.setLabel(i - 1, l[1]);
                command = command + ";" + com;
            }
            String[] labelArray = this.nmr.labelSetter.getLabelArray();
            this.nmr.noeTable.setLabelArray(labelArray);
            this.nmr.coupleTable.setLabelArray(labelArray);
            while ((line = inp.readLine()).trim().length() != 0) {
                String[] l = line.split("\\s+");
                command = command + ";measure " + l[0] + " " + l[1];
                if (l[2] == null || l[2].equals("null")) continue;
                int i = new Integer(l[0]);
                j = new Integer(l[1]);
                this.nmr.noeTable.setExpNoe(l[2], i - 1, j - 1);
            }
            while ((line = inp.readLine()) != null && line.trim().length() != 0) {
                String[] l = line.split("\\s+");
                command = command + ";measure " + l[0] + " " + l[1] + " " + l[2] + " " + l[3];
                if (l[4] == null || l[4].equals("null")) continue;
                int i = new Integer(l[0]);
                j = new Integer(l[3]);
                this.nmr.coupleTable.setExpCouple(l[4], i - 1, j - 1);
            }
            this.nmr.noeTable.updateTables();
            this.nmr.coupleTable.updateTables();
            this.nmr.vwr.script(command);
            return;
        }
        catch (Exception exception) {
            return;
        }
        finally {
            try {
                if (inp != null) {
                    inp.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

