/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.services.clientregistration.AbstractClientRegistrationProvider;
import org.keycloak.services.clientregistration.DefaultClientRegistrationContext;

public class DefaultClientRegistrationProvider
extends AbstractClientRegistrationProvider {
    public DefaultClientRegistrationProvider(KeycloakSession session) {
        super(session);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createDefault(ClientRepresentation client) {
        DefaultClientRegistrationContext context = new DefaultClientRegistrationContext(this.session, client, this);
        client = this.create(context);
        this.validateClient(client, true);
        URI uri = this.session.getContext().getUri().getAbsolutePathBuilder().path(client.getClientId()).build(new Object[0]);
        return Response.created((URI)uri).entity((Object)client).build();
    }

    @GET
    @Path(value="{clientId}")
    @Produces(value={"application/json"})
    public Response getDefault(@PathParam(value="clientId") String clientId) {
        ClientModel client = this.session.getContext().getRealm().getClientByClientId(clientId);
        ClientRepresentation clientRepresentation = this.get(client);
        return Response.ok((Object)clientRepresentation).build();
    }

    @PUT
    @Path(value="{clientId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateDefault(@PathParam(value="clientId") String clientId, ClientRepresentation client) {
        DefaultClientRegistrationContext context = new DefaultClientRegistrationContext(this.session, client, this);
        ResourceServerRepresentation authorizationSettings = client.getAuthorizationSettings();
        client = this.update(clientId, context);
        this.updateAuthorizationSettings(client, authorizationSettings);
        this.validateClient(client, false);
        return Response.ok((Object)client).build();
    }

    @DELETE
    @Path(value="{clientId}")
    public void deleteDefault(@PathParam(value="clientId") String clientId) {
        this.delete(clientId);
    }

    private void updateAuthorizationSettings(ClientRepresentation rep, ResourceServerRepresentation authorizationSettings) {
        rep.setAuthorizationSettings(authorizationSettings);
        ClientModel client = this.session.getContext().getRealm().getClientByClientId(rep.getClientId());
        RepresentationToModel.importAuthorizationSettings((ClientRepresentation)rep, (ClientModel)client, (KeycloakSession)this.session);
    }
}

