/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.keycloak.sdjwt.ArrayDisclosure;
import org.keycloak.sdjwt.DisclosureSpec;
import org.keycloak.sdjwt.SdJwtClaim;
import org.keycloak.sdjwt.SdJwtClaimName;
import org.keycloak.sdjwt.SdJwtSalt;
import org.keycloak.sdjwt.UndisclosedClaim;
import org.keycloak.sdjwt.VisibleSdJwtClaim;

public class SdJwtClaimFactory {
    public static List<SdJwtClaim> parsePayload(ObjectNode objectNode, DisclosureSpec disclosureSpec) {
        ArrayList<SdJwtClaim> claims = new ArrayList<SdJwtClaim>();
        objectNode.properties().forEach(entry -> claims.add(SdJwtClaimFactory.createClaim((String)entry.getKey(), (JsonNode)entry.getValue(), disclosureSpec)));
        return claims;
    }

    private static SdJwtClaim createClaim(String claimName, JsonNode claimValue, DisclosureSpec disclosureSpec) {
        DisclosureSpec.DisclosureData disclosureData = disclosureSpec.getUndisclosedClaim(SdJwtClaimName.of(claimName));
        if (disclosureData != null) {
            return SdJwtClaimFactory.createUndisclosedClaim(claimName, claimValue, disclosureData.getSalt());
        }
        return SdJwtClaimFactory.createArrayOrVisibleClaim(claimName, claimValue, disclosureSpec);
    }

    private static SdJwtClaim createUndisclosedClaim(String claimName, JsonNode claimValue, SdJwtSalt salt) {
        return UndisclosedClaim.builder().withClaimName(claimName).withClaimValue(claimValue).withSalt(salt).build();
    }

    private static SdJwtClaim createArrayOrVisibleClaim(String claimName, JsonNode claimValue, DisclosureSpec disclosureSpec) {
        SdJwtClaimName sdJwtClaimName = SdJwtClaimName.of(claimName);
        Map<Integer, DisclosureSpec.DisclosureData> undisclosedArrayElts = disclosureSpec.getUndisclosedArrayElts(sdJwtClaimName);
        Map<Integer, DisclosureSpec.DisclosureData> decoyArrayElts = disclosureSpec.getDecoyArrayElts(sdJwtClaimName);
        if (undisclosedArrayElts != null || decoyArrayElts != null) {
            return SdJwtClaimFactory.createArrayDisclosure(claimName, claimValue, undisclosedArrayElts, decoyArrayElts);
        }
        return VisibleSdJwtClaim.builder().withClaimName(claimName).withClaimValue(claimValue).build();
    }

    private static SdJwtClaim createArrayDisclosure(String claimName, JsonNode claimValue, Map<Integer, DisclosureSpec.DisclosureData> undisclosedArrayElts, Map<Integer, DisclosureSpec.DisclosureData> decoyArrayElts) {
        ArrayNode arrayNode = SdJwtClaimFactory.validateArrayNode(claimName, claimValue);
        ArrayDisclosure.Builder arrayDisclosureBuilder = ArrayDisclosure.builder().withClaimName(claimName);
        if (undisclosedArrayElts != null) {
            IntStream.range(0, arrayNode.size()).forEach(i -> SdJwtClaimFactory.processArrayElement(arrayDisclosureBuilder, arrayNode.get(i), (DisclosureSpec.DisclosureData)undisclosedArrayElts.get(i)));
        }
        if (decoyArrayElts != null) {
            decoyArrayElts.forEach((key, value) -> arrayDisclosureBuilder.withDecoyElt((Integer)key, value.getSalt()));
        }
        return arrayDisclosureBuilder.build();
    }

    private static ArrayNode validateArrayNode(String claimName, JsonNode claimValue) {
        return Optional.of(claimValue).filter(v -> v.getNodeType() == JsonNodeType.ARRAY).map(v -> (ArrayNode)v).orElseThrow(() -> new IllegalArgumentException("Expected array for claim with name: " + claimName));
    }

    private static void processArrayElement(ArrayDisclosure.Builder builder, JsonNode elementValue, DisclosureSpec.DisclosureData disclosureData) {
        if (disclosureData != null) {
            builder.withUndisclosedElement(disclosureData.getSalt(), elementValue);
        } else {
            builder.withVisibleElement(elementValue);
        }
    }
}

