/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations;

import org.hibernate.cache.spi.access.AccessType;

public enum CacheConcurrencyStrategy {
    NONE,
    READ_ONLY,
    NONSTRICT_READ_WRITE,
    READ_WRITE,
    TRANSACTIONAL;


    public AccessType toAccessType() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> null;
            case 1 -> AccessType.READ_ONLY;
            case 2 -> AccessType.NONSTRICT_READ_WRITE;
            case 3 -> AccessType.READ_WRITE;
            case 4 -> AccessType.TRANSACTIONAL;
        };
    }

    public static CacheConcurrencyStrategy fromAccessType(AccessType accessType) {
        if (accessType == null) {
            return NONE;
        }
        return switch (accessType) {
            default -> throw new IncompatibleClassChangeError();
            case AccessType.READ_ONLY -> READ_ONLY;
            case AccessType.READ_WRITE -> READ_WRITE;
            case AccessType.NONSTRICT_READ_WRITE -> NONSTRICT_READ_WRITE;
            case AccessType.TRANSACTIONAL -> TRANSACTIONAL;
        };
    }

    public static CacheConcurrencyStrategy parse(String name) {
        for (CacheConcurrencyStrategy strategy : CacheConcurrencyStrategy.values()) {
            if (!strategy.isMatch(name)) continue;
            return strategy;
        }
        return null;
    }

    private boolean isMatch(String name) {
        AccessType accessType = this.toAccessType();
        return accessType != null && accessType.getExternalName().equalsIgnoreCase(name) || this.name().equalsIgnoreCase(name);
    }
}

