/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.annotations;

import org.eclipse.jetty.ee8.annotations.AbstractDiscoverableAnnotationHandler;
import org.eclipse.jetty.ee8.annotations.AnnotationParser;
import org.eclipse.jetty.ee8.annotations.WebServletAnnotation;
import org.eclipse.jetty.ee8.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServletAnnotationHandler
extends AbstractDiscoverableAnnotationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WebServletAnnotationHandler.class);

    public WebServletAnnotationHandler(WebAppContext context) {
        super(context);
    }

    @Override
    public void handle(AnnotationParser.ClassInfo info, String annotationName) {
        if (annotationName == null || !"javax.servlet.annotation.WebServlet".equals(annotationName)) {
            return;
        }
        WebServletAnnotation annotation = new WebServletAnnotation(this._context, info.getClassName(), info.getContainingResource());
        this.addAnnotation(annotation);
    }

    @Override
    public void handle(AnnotationParser.FieldInfo info, String annotationName) {
        if (annotationName == null || !"javax.servlet.annotation.WebServlet".equals(annotationName)) {
            return;
        }
        LOG.warn("@WebServlet annotation not supported for fields");
    }

    @Override
    public void handle(AnnotationParser.MethodInfo info, String annotationName) {
        if (annotationName == null || !"javax.servlet.annotation.WebServlet".equals(annotationName)) {
            return;
        }
        LOG.warn("@WebServlet annotation not supported for methods");
    }
}

