/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesResponse;
import software.amazon.awssdk.services.ec2.model.SecurityGroupRule;

public class DescribeSecurityGroupRulesIterable
implements SdkIterable<DescribeSecurityGroupRulesResponse> {
    private final Ec2Client client;
    private final DescribeSecurityGroupRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSecurityGroupRulesIterable(Ec2Client client, DescribeSecurityGroupRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSecurityGroupRulesResponseFetcher();
    }

    public Iterator<DescribeSecurityGroupRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SecurityGroupRule> securityGroupRules() {
        Function<DescribeSecurityGroupRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityGroupRules() != null) {
                return response.securityGroupRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSecurityGroupRulesResponseFetcher
    implements SyncPageFetcher<DescribeSecurityGroupRulesResponse> {
        private DescribeSecurityGroupRulesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSecurityGroupRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSecurityGroupRulesResponse nextPage(DescribeSecurityGroupRulesResponse previousPage) {
            if (previousPage == null) {
                return DescribeSecurityGroupRulesIterable.this.client.describeSecurityGroupRules(DescribeSecurityGroupRulesIterable.this.firstRequest);
            }
            return DescribeSecurityGroupRulesIterable.this.client.describeSecurityGroupRules((DescribeSecurityGroupRulesRequest)((Object)DescribeSecurityGroupRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

