/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.eventstream;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.eventstream.ClientConnection;
import software.amazon.awssdk.crt.eventstream.Header;
import software.amazon.awssdk.crt.eventstream.MessageType;

public abstract class ClientConnectionHandler
implements AutoCloseable {
    protected ClientConnection clientConnection;

    protected abstract void onConnectionSetup(ClientConnection var1, int var2);

    void onConnectionSetupShim(long connectionPtr, int errorCode) {
        if (connectionPtr != 0L) {
            this.clientConnection = new ClientConnection(connectionPtr);
        }
        this.onConnectionSetup(this.clientConnection, errorCode);
    }

    protected abstract void onProtocolMessage(List<Header> var1, byte[] var2, MessageType var3, int var4);

    private void onProtocolMessage(byte[] headersPayload, byte[] payload, int messageType, int messageFlags) {
        ArrayList<Header> headers = new ArrayList<Header>();
        ByteBuffer headersBuffer = ByteBuffer.wrap(headersPayload);
        while (headersBuffer.hasRemaining()) {
            Header header = Header.fromByteBuffer(headersBuffer);
            headers.add(header);
        }
        this.onProtocolMessage(headers, payload, MessageType.fromEnumValue(messageType), messageFlags);
    }

    private void onConnectionClosedShim(int closeReason) {
        this.onConnectionClosed(closeReason);
    }

    public CompletableFuture<Integer> getConnectionClosedFuture() {
        return this.clientConnection.getClosedFuture();
    }

    protected void onConnectionClosed(int closeReason) {
        this.close();
    }

    @Override
    public void close() {
        if (this.clientConnection != null) {
            if (this.clientConnection.isOpen()) {
                this.clientConnection.closeConnection(0);
            }
            this.clientConnection.decRef();
            this.clientConnection = null;
        }
    }
}

