/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GrokProcessor
extends ProcessorBase
implements ProcessorVariant,
ToCopyableBuilder<Builder, GrokProcessor> {
    @Nonnull
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    @Nonnull
    private final Map<String, String> patternDefinitions;
    @Nonnull
    private final List<String> patterns;
    @Nullable
    private final Boolean traceMatch;
    public static final JsonpDeserializer<GrokProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GrokProcessor::setupGrokProcessorDeserializer);

    private GrokProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.patternDefinitions = ApiTypeHelper.unmodifiable(builder.patternDefinitions);
        this.patterns = ApiTypeHelper.unmodifiableRequired(builder.patterns, (Object)this, "patterns");
        this.traceMatch = builder.traceMatch;
    }

    public static GrokProcessor of(Function<Builder, ObjectBuilder<GrokProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Grok;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nonnull
    public final Map<String, String> patternDefinitions() {
        return this.patternDefinitions;
    }

    @Nonnull
    public final List<String> patterns() {
        return this.patterns;
    }

    @Nullable
    public final Boolean traceMatch() {
        return this.traceMatch;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.patternDefinitions)) {
            generator.writeKey("pattern_definitions");
            generator.writeStartObject();
            for (Map.Entry entry : this.patternDefinitions.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("patterns");
        generator.writeStartArray();
        for (String string : this.patterns) {
            generator.write(string);
        }
        generator.writeEnd();
        if (this.traceMatch != null) {
            generator.writeKey("trace_match");
            generator.write(this.traceMatch.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGrokProcessorDeserializer(ObjectDeserializer<Builder> op) {
        GrokProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::patternDefinitions, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "pattern_definitions");
        op.add(Builder::patterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "patterns");
        op.add(Builder::traceMatch, JsonpDeserializer.booleanDeserializer(), "trace_match");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreMissing);
        result = 31 * result + Objects.hashCode(this.patternDefinitions);
        result = 31 * result + this.patterns.hashCode();
        result = 31 * result + Objects.hashCode(this.traceMatch);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrokProcessor other = (GrokProcessor)o;
        return this.field.equals(other.field) && Objects.equals(this.ignoreMissing, other.ignoreMissing) && Objects.equals(this.patternDefinitions, other.patternDefinitions) && this.patterns.equals(other.patterns) && Objects.equals(this.traceMatch, other.traceMatch);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GrokProcessor> {
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private Map<String, String> patternDefinitions;
        private List<String> patterns;
        @Nullable
        private Boolean traceMatch;

        public Builder() {
        }

        private Builder(GrokProcessor o) {
            super(o);
            this.field = o.field;
            this.ignoreMissing = o.ignoreMissing;
            this.patternDefinitions = Builder._mapCopy(o.patternDefinitions);
            this.patterns = Builder._listCopy(o.patterns);
            this.traceMatch = o.traceMatch;
        }

        private Builder(Builder o) {
            super(o);
            this.field = o.field;
            this.ignoreMissing = o.ignoreMissing;
            this.patternDefinitions = Builder._mapCopy(o.patternDefinitions);
            this.patterns = Builder._listCopy(o.patterns);
            this.traceMatch = o.traceMatch;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Nonnull
        public final Builder patternDefinitions(Map<String, String> map) {
            this.patternDefinitions = Builder._mapPutAll(this.patternDefinitions, map);
            return this;
        }

        @Nonnull
        public final Builder patternDefinitions(String key, String value) {
            this.patternDefinitions = Builder._mapPut(this.patternDefinitions, key, value);
            return this;
        }

        @Nonnull
        public final Builder patterns(List<String> list) {
            this.patterns = Builder._listAddAll(this.patterns, list);
            return this;
        }

        @Nonnull
        public final Builder patterns(String value, String ... values) {
            this.patterns = Builder._listAdd(this.patterns, value, values);
            return this;
        }

        @Nonnull
        public final Builder traceMatch(@Nullable Boolean value) {
            this.traceMatch = value;
            return this;
        }

        @Override
        @Nonnull
        public GrokProcessor build() {
            this._checkSingleUse();
            return new GrokProcessor(this);
        }
    }
}

